/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.retry.AbstractDelayedRetry;

public class DefaultRetry
extends AbstractDelayedRetry {
    private final EnumSet<Status.Family> successFamilies = EnumSet.of(Status.Family.SUCCESSFUL);
    private final EnumSet<Status> successStati = EnumSet.of(Status.OK);
    private final EnumSet<Status.Family> retryFamilies = EnumSet.noneOf(Status.Family.class);
    private final EnumSet<Status> retryStati = EnumSet.noneOf(Status.class);
    private final Set<Class<? extends Throwable>> retryThrowableClasses = new HashSet<Class<? extends Throwable>>();

    public DefaultRetry clear() {
        this.successFamilies.clear();
        this.successStati.clear();
        this.retryFamilies.clear();
        this.retryStati.clear();
        this.retryThrowableClasses.clear();
        return this;
    }

    public DefaultRetry succeedOn(Status.Family ... families) {
        this.successFamilies.addAll(Arrays.asList(families));
        return this;
    }

    public DefaultRetry succeedOn(Status ... stati) {
        this.successStati.addAll(Arrays.asList(stati));
        return this;
    }

    public DefaultRetry retryOn(Status.Family ... families) {
        this.retryFamilies.addAll(Arrays.asList(families));
        return this;
    }

    public DefaultRetry retryOn(Status ... stati) {
        this.retryStati.addAll(Arrays.asList(stati));
        return this;
    }

    public final DefaultRetry retryOn(Class<? extends Throwable> ... throwableClasses) {
        this.retryThrowableClasses.addAll(Arrays.asList(throwableClasses));
        return this;
    }

    @Override
    protected boolean isOk(Status status) {
        if (status == null) {
            return false;
        }
        Status.Family family = status.getFamily();
        if (this.successFamilies.contains((Object)family)) {
            return true;
        }
        return this.successStati.contains((Object)status);
    }

    @Override
    protected boolean isRetryable(IRequestBuilder builder, Status status, Throwable throwable) {
        if (status != null) {
            Status.Family family = status.getFamily();
            if (this.retryFamilies.contains((Object)family)) {
                return true;
            }
            if (this.retryStati.contains((Object)status)) {
                return true;
            }
        }
        if (throwable == null) {
            return false;
        }
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            Class<?> throwableClass = cause.getClass();
            for (Class<? extends Throwable> retryThrowableClass : this.retryThrowableClasses) {
                if (!retryThrowableClass.isAssignableFrom(throwableClass)) continue;
                return true;
            }
        }
        return false;
    }
}

