/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.get;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.get.IGetAccountReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestProcessor;
import oracle.cloudstorage.api.request.builder.IMethodRequestBuilder;
import oracle.cloudstorage.api.request.builder.IRequestExecutor;
import oracle.cloudstorage.api.retry.RetryException;

public interface IGetRequestBuilder
extends IMethodRequestBuilder<IGetRequestBuilder, RetryStrategy, IGetRequestProcessor> {
    public int getChunkSize();

    public boolean ignoreStriping();

    public boolean ignoreEncryption();

    public static interface Cryptography
    extends IRequestExecutor {
        @Override
        public IGetObjectReply send() throws RetryException, InterruptedException;
    }

    public static interface Stripe
    extends Cryptography {
        public Cryptography ignoreEncryption(boolean var1);

        public Cryptography ignoreEncryption();
    }

    public static interface Object
    extends IMethodRequestBuilder.Object,
    Stripe {
        public Stripe ignoreStriping(boolean var1);

        public Stripe ignoreStriping();
    }

    public static interface Container
    extends IMethodRequestBuilder.Container<Object>,
    IRequestExecutor {
        @Override
        public IGetContainerReply send() throws RetryException;
    }

    public static interface Account
    extends IMethodRequestBuilder.Account<Container>,
    IRequestExecutor {
        @Override
        public IGetAccountReply send() throws RetryException;
    }

    public static interface QueryParam
    extends Account,
    IMethodRequestBuilder.QueryParam<QueryParam, Account, Container> {
        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> var1);

        @Override
        public Account account(String var1);
    }

    public static interface Header
    extends QueryParam,
    IMethodRequestBuilder.Header<Header, QueryParam, Account, Container> {
    }

    public static interface Buffer
    extends Header,
    IRequestBuilder.Buffer {
        @Override
        public Header buffer(int var1);
    }

    public static interface Chunk
    extends Buffer,
    IRequestBuilder.Chunk {
        @Override
        public Buffer chunk();

        @Override
        public Buffer chunk(boolean var1);

        @Override
        public Buffer chunk(int var1);
    }

    public static interface ReadTimeout
    extends Chunk,
    IMethodRequestBuilder.ReadTimeout<Header, QueryParam, Account, Container> {
        @Override
        public Chunk read(long var1, TimeUnit var3);
    }

    public static interface ConnectTimeout
    extends ReadTimeout,
    IMethodRequestBuilder.ConnectTimeout<ReadTimeout, Header, QueryParam, Account, Container> {
    }

    public static interface RetryStrategy
    extends ConnectTimeout,
    IMethodRequestBuilder.RetryStrategy<ConnectTimeout, ReadTimeout, Header, QueryParam, Account, Container> {
    }
}

