/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Container {
    private final String name;
    private final int count;
    private final long size;
    private final Map<String, String> customMetadata;

    public static Container create(String name, int count, long size, Map<String, String> mdata) {
        return new Container(name, count, size, mdata);
    }

    private Container(String name, int count, long size, Map<String, String> metadata) {
        this.name = name;
        this.count = count;
        this.size = size;
        this.customMetadata = metadata == null ? new HashMap() : metadata;
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, String> getCustomMetadata() {
        return Collections.unmodifiableMap(this.customMetadata);
    }

    public void removeMetadata(String key) {
        this.customMetadata.remove(key);
    }

    public void updateMetadata(String key, String val) {
        this.customMetadata.put(key, val);
    }

    public String getMetadataValue(String metadataKey) {
        if (this.customMetadata == null || this.customMetadata.size() == 0) {
            return null;
        }
        String normKey = Character.toUpperCase(metadataKey.charAt(0)) + metadataKey.substring(1).toLowerCase(Locale.ENGLISH);
        String val = this.customMetadata.get(normKey);
        if (val == null) {
            val = this.customMetadata.get(metadataKey);
        }
        return val;
    }
}

