/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.retry.v2;

import com.ibm.cloud.objectstorage.retry.v2.RetryCondition;
import com.ibm.cloud.objectstorage.retry.v2.RetryPolicyContext;
import com.ibm.cloud.objectstorage.util.ValidationUtils;

public class MaxNumberOfRetriesCondition
implements RetryCondition {
    private final int maxNumberOfRetries;

    public MaxNumberOfRetriesCondition(int maxNumberOfRetries) {
        this.maxNumberOfRetries = ValidationUtils.assertIsPositive(maxNumberOfRetries, "maxNumberOfRetries");
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return context.retriesAttempted() < this.maxNumberOfRetries;
    }
}

