/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.core.transport.internal.OSBadBooleanDeserializer;
import org.openstack4j.model.identity.v2.Role;
import org.openstack4j.model.identity.v2.builder.RoleBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="role")
public class KeystoneRole
implements Role {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    @JsonDeserialize(using=OSBadBooleanDeserializer.class)
    private Boolean enabled = true;
    private String tenantId;
    private String serviceId;

    public static RoleBuilder builder() {
        return new RoleConcreteBuilder();
    }

    @Override
    public RoleBuilder toBuilder() {
        return new RoleConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("enabled", (Object)this.enabled).add("tenantId", (Object)this.tenantId).add("serviceId", (Object)this.serviceId).toString();
    }

    public static class RoleConcreteBuilder
    implements RoleBuilder {
        private KeystoneRole model;

        RoleConcreteBuilder() {
            this(new KeystoneRole());
        }

        RoleConcreteBuilder(KeystoneRole model) {
            this.model = model;
        }

        @Override
        public RoleBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public RoleBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public RoleBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public RoleBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public RoleBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public Role build() {
            return this.model;
        }

        @Override
        public RoleBuilder from(Role in) {
            this.model = (KeystoneRole)in;
            return this;
        }
    }

    public static class Roles
    extends ListResult<KeystoneRole> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="roles")
        private List<KeystoneRole> list;

        @Override
        protected List<KeystoneRole> value() {
            return this.list;
        }
    }
}

