/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.filters;

import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import oracle.cloud.storage.nls.ClientMessage;

public final class StreamLogger
extends ClientFilter {
    private static final Logger LOGGER = Logger.getLogger(StreamLogger.class.getName());
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    private final Logger logger;
    private long _id = 0L;

    public StreamLogger() {
        this(LOGGER);
    }

    public StreamLogger(Logger logger) {
        this.logger = logger;
    }

    private void log(StringBuilder b) {
        this.logger.info(b.toString());
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(Long.toString(id)).append(" ");
        return b;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        long id = ++this._id;
        this.logRequest(id, request);
        ClientResponse response = this.getNext().handle(request);
        this.logResponse(id, response);
        return response;
    }

    private void logRequest(long id, ClientRequest request) {
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, id, request);
        this.printRequestHeaders(b, id, (MultivaluedMap<String, Object>)request.getHeaders());
        this.log(b);
        if (request.getEntity() != null) {
            request.setAdapter((ClientRequestAdapter)new Adapter(request.getAdapter()));
        }
    }

    private void printRequestLine(StringBuilder b, long id, ClientRequest request) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(ClientMessage.outboundRequest()).append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getURI().toASCIIString()).append("\n");
    }

    private void printRequestHeaders(StringBuilder b, long id, MultivaluedMap<String, Object> headers) {
        for (Map.Entry e : headers.entrySet()) {
            List val = (List)e.getValue();
            String header = (String)e.getKey();
            if (val.size() == 1) {
                this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(ClientRequest.getHeaderValue(val.get(0))).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (Object o : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append(ClientRequest.getHeaderValue(o));
            }
            this.prefixId(b, id).append(REQUEST_PREFIX).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }

    private void logResponse(long id, ClientResponse response) {
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, id, response);
        this.printResponseHeaders(b, id, (MultivaluedMap<String, String>)response.getHeaders());
        this.logger.info(b.toString());
        response.setEntityInputStream((InputStream)new LoggingFilter(response.getEntityInputStream()));
    }

    private void printResponseLine(StringBuilder b, long id, ClientResponse response) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append(ClientMessage.inboundResponse()).append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).append("\n");
    }

    private void printResponseHeaders(StringBuilder b, long id, MultivaluedMap<String, String> headers) {
        for (Map.Entry e : headers.entrySet()) {
            String header = (String)e.getKey();
            for (String value : (List)e.getValue()) {
                this.prefixId(b, id).append(RESPONSE_PREFIX).append(header).append(": ").append(value).append("\n");
            }
        }
        this.prefixId(b, id).append(RESPONSE_PREFIX).append("\n");
    }

    private final class LoggingOutputStream
    extends OutputStream {
        OutputStream out;

        LoggingOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b) throws IOException {
            StreamLogger.this.logger.info(new String(b, StandardCharsets.UTF_8));
            this.out.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            StreamLogger.this.logger.info(Integer.toString(b));
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            StreamLogger.this.logger.info(new String(Arrays.copyOfRange(b, off, len), StandardCharsets.UTF_8));
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private final class LoggingFilter
    extends FilterInputStream {
        private PrintWriter p;

        LoggingFilter(InputStream in) {
            super(in);
            this.p = new PrintWriter(new BufferedWriter(new LogWriter()));
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                this.p.print((char)b);
            } else {
                this.p.flush();
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((len = this.in.read(b, off, len)) != -1) {
                this.p.print(new String(Arrays.copyOfRange(b, off, len), StandardCharsets.UTF_8));
            } else {
                this.p.flush();
            }
            return len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int len = this.in.read(b);
            if (len != -1) {
                this.p.print(new String(Arrays.copyOfRange(b, 0, b.length), StandardCharsets.UTF_8));
            } else {
                this.p.flush();
            }
            return len;
        }

        @Override
        public void close() throws IOException {
            this.p.close();
        }
    }

    private final class LogWriter
    extends Writer {
        private LogWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] b, int off, int len) {
            StreamLogger.this.logger.info(new String(Arrays.copyOfRange(b, off, len)));
        }
    }

    private final class Adapter
    extends AbstractClientRequestAdapter {
        Adapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new LoggingOutputStream(this.getAdapter().adapt(request, out));
        }
    }
}

