/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileString;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.SOAPConnect;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.URLConnect;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.xml.XML2TableParser;
import org.opengion.fukurou.xml.XSLT;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class URLConnectTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.7.2 (2014/06/20)";
    private static final long serialVersionUID = 577220140620L;
    private static final String DEFAULT_USER = "SYSTEM:MANAGER";
    private String urlStr = null;
    private String[] keys = null;
    private String[] vals = null;
    private String xslFile = null;
    private String saveFile = null;
    private String postKey = null;
    private String postData = null;
    private int timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
    private boolean useSystemUser = true;
    private String authUserPass = null;
    private boolean display = false;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String method = "GET";
    private boolean errNglctFlag = false;
    private String soapNameSpace = null;
    private String soapMethodName = null;
    private transient DBTableModel table = null;
    private String tableId = "h_tblmdl";
    private String rowKey = null;
    private String[] colKeys = null;
    private String[] rtnKeys = null;
    private String encode = "UTF-8";
    private boolean isTableOut = false;
    private boolean isOutParse = false;
    private boolean isMainTrans = true;
    private String storageType = null;
    private String bucketName = null;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        if (this.rowKey != null || this.colKeys != null || this.rtnKeys != null) {
            this.isOutParse = true;
            if (this.rowKey != null || this.colKeys != null) {
                this.isTableOut = true;
                this.useMainTrans(this.isMainTrans);
                this.startQueryTransaction(this.tableId);
            }
        }
        if (this.postData != null) {
            return 0;
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.postData = this.getBodyString();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        ByteArrayOutputStream byteArrayOutputStream;
        block21: {
            this.debugPrint();
            if (!this.useTag()) {
                return 6;
            }
            URLConnect uRLConnect = null;
            byteArrayOutputStream = null;
            try {
                uRLConnect = this.connect();
                Writer writer = null;
                if (this.isOutParse) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new HybsSystemException("\u4e0d\u6b63\u306a\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002[UTF-8]", unsupportedEncodingException);
                    }
                } else if (this.display) {
                    writer = FileUtil.getNonFlushPrintWriter((Writer)this.pageContext.getOut());
                } else if (this.saveFile != null) {
                    writer = FileUtil.getPrintWriter((File)new File(this.saveFile), (String)"UTF-8");
                }
                if (writer != null) {
                    XSLT xSLT;
                    if (this.xslFile != null) {
                        xSLT = new XSLT();
                        xSLT.setXslFile(this.xslFile);
                        xSLT.setOutFile(writer);
                        xSLT.transform((Reader)uRLConnect.getReader());
                        xSLT.close();
                    } else {
                        ((Writer)writer).write(uRLConnect.readData());
                    }
                    Closer.ioClose((Closeable)writer);
                    xSLT = HybsFileOperationFactory.create(this.storageType, this.bucketName, this.saveFile);
                    if (!xSLT.isLocal()) {
                        File file = new File(this.saveFile);
                        FileUtil.copy((File)file, (File)xSLT);
                        file.delete();
                    }
                }
            }
            catch (IOException iOException) {
                String string = "\u30c7\u30fc\u30bf\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " url=[" + this.urlStr + "]" + " message=[" + (uRLConnect == null ? "NO_CONNECTION" : uRLConnect.getMessage()) + "]";
                if (this.errNglctFlag) {
                    LogWriter.log((String)string);
                    break block21;
                }
                throw new HybsSystemException(string, iOException);
            }
            finally {
                if (uRLConnect != null) {
                    uRLConnect.disconnect();
                }
            }
        }
        if (this.isOutParse) {
            this.parse(new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
            if (this.isTableOut && this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("URLConnectTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        return 6;
    }

    private URLConnect connect() throws IOException {
        if (this.useSystemUser) {
            this.authUserPass = DEFAULT_USER;
        }
        URLConnect uRLConnect = null;
        if ("SOAP".equalsIgnoreCase(this.method)) {
            if (this.soapNameSpace == null || this.soapNameSpace.length() == 0 || this.soapMethodName == null || this.soapMethodName.length() == 0) {
                String string = "SOAP\u63a5\u7d9a\u306e\u5834\u5408\u3001soapNameSpace\u53ca\u3073soapMethodName\u306f\u5fc5\u305a\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002";
                throw new HybsSystemException(string);
            }
            uRLConnect = this.postData != null && this.postData.length() > 0 ? new SOAPConnect(this.urlStr, this.authUserPass, this.soapNameSpace, this.soapMethodName, this.postData) : new SOAPConnect(this.urlStr, this.authUserPass, this.soapNameSpace, this.soapMethodName, this.keys, this.vals);
        } else {
            String string = XHTMLTag.urlEncode((String[])this.keys, (String[])this.vals);
            if (this.postKey != null) {
                this.method = "POST";
                String string2 = this.postKey + "=" + this.postData;
                string = string + "&" + string2;
            }
            if (!"POST".equals(this.method)) {
                this.urlStr = XHTMLTag.addUrlEncode((String)this.urlStr, (String)string);
            }
            uRLConnect = new URLConnect(this.urlStr, this.authUserPass);
            if ("POST".equals(this.method) && this.keys != null && this.vals != null) {
                uRLConnect.setPostData(string);
            }
        }
        if (this.proxyHost != null) {
            uRLConnect.setProxy(this.proxyHost, this.proxyPort);
        }
        if (this.encode != null && this.encode.length() > 0) {
            uRLConnect.setCharset(this.encode);
        }
        if (this.timeout >= 0) {
            uRLConnect.setTimeout(this.timeout);
        }
        uRLConnect.connect();
        return uRLConnect;
    }

    private void parse(InputStream inputStream) {
        XML2TableParser xML2TableParser = new XML2TableParser(inputStream);
        xML2TableParser.setTableCols(this.rowKey, this.colKeys);
        xML2TableParser.setReturnCols(this.rtnKeys);
        xML2TableParser.parse();
        if (this.isTableOut) {
            this.table = DBTableModelUtil.makeDBTable(xML2TableParser.getCols(), xML2TableParser.getData(), this.getResource());
        }
        if (this.rtnKeys != null) {
            Map map = xML2TableParser.getRtn();
            for (Map.Entry entry : map.entrySet()) {
                this.setRequestAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected void release2() {
        super.release2();
        this.urlStr = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.keys = null;
        this.vals = null;
        this.xslFile = null;
        this.saveFile = null;
        this.postKey = null;
        this.postData = null;
        this.timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
        this.useSystemUser = true;
        this.authUserPass = null;
        this.display = false;
        this.method = "GET";
        this.errNglctFlag = false;
        this.soapNameSpace = null;
        this.soapMethodName = null;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.rowKey = null;
        this.colKeys = null;
        this.rtnKeys = null;
        this.isTableOut = false;
        this.isOutParse = false;
        this.encode = "UTF-8";
        this.isMainTrans = true;
        this.storageType = null;
        this.bucketName = null;
    }

    public void setUrl(String string) {
        this.urlStr = StringUtil.nval((String)this.getRequestParameter(string), (String)this.urlStr);
    }

    public void setProxyHost(String string) {
        this.proxyHost = StringUtil.nval((String)this.getRequestParameter(string), (String)this.proxyHost);
        this.useSystemUser = false;
    }

    public void setProxyPort(String string) {
        this.proxyPort = StringUtil.nval((String)this.getRequestParameter(string), (int)this.proxyPort);
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setMethod(String string) {
        this.method = StringUtil.nval((String)this.getRequestParameter(string), (String)this.method);
    }

    public void setUseSystemUser(String string) {
        this.useSystemUser = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSystemUser);
    }

    public void setAuthUserPass(String string) {
        this.authUserPass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authUserPass);
    }

    public void setXslFile(String string) {
        this.xslFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.xslFile));
    }

    public void setDisplay(String string) {
        this.display = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.display);
        if (this.display && this.saveFile != null) {
            String string2 = "display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setSaveFile(String string) {
        this.saveFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.saveFile));
        if (this.display) {
            String string2 = "display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
    }

    public void setPostKey(String string) {
        this.postKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.postKey);
    }

    public void setPostFile(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            FileString fileString = new FileString();
            fileString.setFilename(HybsSystem.url2dir(string2));
            this.postData = fileString.getValue();
        }
    }

    public void setTimeout(String string) {
        this.timeout = StringUtil.nval((String)this.getRequestParameter(string), (int)this.timeout);
    }

    public void setErrNeglect(String string) {
        this.errNglctFlag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.errNglctFlag);
    }

    public void setSoapNameSpace(String string) {
        this.soapNameSpace = StringUtil.nval((String)this.getRequestParameter(string), (String)this.soapNameSpace);
    }

    public void setSoapMethodName(String string) {
        this.soapMethodName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.soapMethodName);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setRowKey(String string) {
        this.rowKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rowKey);
    }

    public void setColKeys(String string) {
        this.colKeys = StringUtil.csv2Array((String)this.getRequestParameter(string));
    }

    public void setRtnKeys(String string) {
        this.rtnKeys = StringUtil.csv2Array((String)this.getRequestParameter(string));
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    @Override
    protected String getTagName() {
        return "urlConnect";
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setStorageType(String string) {
        this.storageType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.storageType);
    }

    public void setBucketName(String string) {
        this.bucketName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.bucketName);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("method", (Object)this.method).println("urlStr", (Object)this.urlStr).println("keys", (Object)StringUtil.array2csv((String[])this.keys)).println("vals", (Object)StringUtil.array2csv((String[])this.vals)).println("proxyHost", (Object)this.proxyHost).println("proxyPort", (Object)this.proxyPort).println("timeout", (Object)this.timeout).println("useSystemUser", (Object)this.useSystemUser).println("authUserPass", (Object)this.authUserPass).println("display", (Object)this.display).println("postData", (Object)this.postData).println("xslFile", (Object)this.xslFile).println("saveFile", (Object)this.saveFile).println("errNglctFlag", (Object)this.errNglctFlag).println("soapNameSpace", (Object)this.soapNameSpace).println("soapMethodName", (Object)this.soapMethodName).println("tableId", (Object)this.tableId).println("rowKey", (Object)this.rowKey).println("colKeys", (Object)StringUtil.array2csv((String[])this.colKeys)).println("rtnKeys", (Object)StringUtil.array2csv((String[])this.rtnKeys)).println("storageType", (Object)this.storageType).println("bucketName", (Object)this.bucketName).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

