/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.NetworkService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkUpdate;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.NeutronNetwork;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NetworkServiceImpl
extends BaseNetworkingServices
implements NetworkService {
    private BaseOpenStackService.Invocation<NeutronNetwork.Networks> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronNetwork.Networks> invocation = this.get(NeutronNetwork.Networks.class, "/networks");
        if (filteringParams == null) {
            return invocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            invocation = invocation.param(entry.getKey(), entry.getValue());
        }
        return invocation;
    }

    @Override
    public List<? extends Network> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronNetwork.Networks> invocation = this.buildInvocation(filteringParams);
        return invocation.execute().getList();
    }

    @Override
    public List<? extends Network> list() {
        return this.get(NeutronNetwork.Networks.class, this.uri("/networks", new Object[0])).execute().getList();
    }

    @Override
    public ActionResponse delete(String networkId) {
        Preconditions.checkNotNull((Object)networkId);
        return this.deleteWithResponse(this.uri("/networks/%s", networkId)).execute();
    }

    @Override
    public Network get(String networkId) {
        Preconditions.checkNotNull((Object)networkId);
        return this.get(NeutronNetwork.class, this.uri("/networks/%s", networkId)).execute();
    }

    @Override
    public Network create(Network network) {
        Preconditions.checkNotNull((Object)network);
        return this.post(NeutronNetwork.class, this.uri("/networks", new Object[0])).entity(network).execute();
    }

    @Override
    public Network update(String networkId, NetworkUpdate network) {
        Preconditions.checkNotNull((Object)networkId);
        Preconditions.checkNotNull((Object)network, (Object)"network");
        return this.put(NeutronNetwork.class, this.uri("/networks/%s", networkId)).entity(network).execute();
    }
}

