/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.openstack4j.model.heat.StackUpdate;
import org.openstack4j.model.heat.builder.StackUpdateBuilder;
import org.openstack4j.openstack.heat.utils.Environment;
import org.openstack4j.openstack.heat.utils.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatStackUpdate
implements StackUpdate {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HeatStackUpdate.class);
    @JsonProperty(value="template")
    private String template;
    @JsonProperty(value="template_url")
    private String templateURL;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="timeout_mins")
    private Long timeoutMins;
    @JsonProperty(value="environment")
    private String environment;
    @JsonProperty(value="files")
    private Map<String, String> files = new HashMap<String, String>();
    @JsonProperty(value="tags")
    private String tags;

    public static StackUpdateBuilder builder() {
        return new HeatStackUpdateConcreteBuilder();
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public String getTempateURL() {
        return this.templateURL;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public String getTags() {
        return this.tags;
    }

    @Override
    public StackUpdateBuilder toBuilder() {
        return new HeatStackUpdateConcreteBuilder(this);
    }

    public static class HeatStackUpdateConcreteBuilder
    implements StackUpdateBuilder {
        private HeatStackUpdate model;

        public HeatStackUpdateConcreteBuilder() {
            this(new HeatStackUpdate());
        }

        public HeatStackUpdateConcreteBuilder(HeatStackUpdate model) {
            this.model = model;
        }

        @Override
        public StackUpdate build() {
            return this.model;
        }

        @Override
        public StackUpdateBuilder from(StackUpdate in) {
            this.model = (HeatStackUpdate)in;
            return this;
        }

        @Override
        public StackUpdateBuilder template(String template) {
            this.model.template = template;
            return this;
        }

        @Override
        public StackUpdateBuilder templateFromFile(String tplFile) {
            try {
                Template tpl = new Template(tplFile);
                this.model.template = tpl.getTplContent();
                this.model.files.putAll(tpl.getFiles());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return this;
        }

        @Override
        public StackUpdateBuilder templateURL(String templateURL) {
            this.model.templateURL = templateURL;
            return this;
        }

        @Override
        public StackUpdateBuilder parameters(Map<String, String> parameters) {
            this.model.parameters = parameters;
            return this;
        }

        @Override
        public StackUpdateBuilder timeoutMins(Long timeoutMins) {
            this.model.timeoutMins = timeoutMins;
            return this;
        }

        @Override
        public StackUpdateBuilder environment(String environment) {
            this.model.environment = environment;
            return this;
        }

        @Override
        public StackUpdateBuilder environmentFromFile(String envFile) {
            try {
                Environment env = new Environment(envFile);
                this.model.environment = env.getEnvContent();
                this.model.files.putAll(env.getFiles());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return this;
        }

        @Override
        public StackUpdateBuilder files(Map<String, String> files) {
            this.model.files = files;
            return this;
        }

        @Override
        public StackUpdateBuilder tags(String tags) {
            this.model.tags = tags;
            return this;
        }
    }
}

