<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:value command="SET" key="DAEMON_CLASS" value="org.opengion.plugin.daemon.Daemon_URLConnect" />

<!-- period は、ｍｓ単位で指定する必要があるため、１０００倍しています。 -->
<og:schedule
	command		= "{@CMD}"
	scope		= "request"
	timerTask	= "{@DAEMON_CLASS}"
	name		= "{@NAME_JA}"
	comment		= "Start-up By {@USER.INFO} {@url}"
	singleton	= "true"
	delay		= "0"
	period		= "{@PERIOD}000"
	fixedDelay	= "true"
	keys		= "url,useSystemUser,authUserPass,keys,vals,method,debug"
	vals		= "{@url},{@useSystemUser},{@authUserPass},{@keys},{@vals},{@method},{@debug}"
/>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command		= "{@command}" 
	scope		= "request"
	writable	= "false"
	checked		= "{@checked}"
	startNo		= "{@startNo}" 
	pageSize	= "{@pageSize}"  />

<!-- システムパラメータテーブル(GE12)への登録 -->
<!-- PARAM_ID を CONTEXT_INITIAL_CALL_URL_ で登録するとTomcat起動時に再実行されます。 -->
<og:equals val1="{@CMD}" val2="SET" >
	<og:value command="SQL">
	  <jsp:text>
		SELECT COUNT(*) AS CNT FROM GE12
			WHERE SYSTEM_ID = 'GE'
			AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_{@NAME_JA}'
			AND   FGJ = '1'
			AND   CONTXT_PATH = '{@SYS.HOST_URL}'
	  </jsp:text>
	</og:value>

	<!-- 存在しなければ、追加 -->
	<og:equals val1="{@CNT}" val2="0" >
	  <og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			INSERT INTO GE12
				(SYSTEM_ID,PARAM_ID,PARAM,PARAM_LVL,TITLE,CONTENTS,SEQNO,KBSAKU,
				 FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD,CONTXT_PATH)
			VALUES
				('GE','CONTEXT_INITIAL_CALL_URL_{@NAME_JA}',
				'<og:link href="{@SYS.CONTEXT_URL}jsp/URLD/result.jsp" hrefOnly="true" useGamenId="false"
					keys="command,url,proxyHost,proxyPort,useSystemUser,authUserPass,keys,vals,method,debug,PERIOD,CMD,NAME_JA"
					vals="NEW,{@url},{@proxyHost},{@proxyPort},{@useSystemUser},{@authUserPass},{@keys},{@vals},{@method},{@debug},{@PERIOD},SET,{@NAME_JA}" />',
				 '7','','','1000','1',
				 '1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}','{@SYS.HOST_URL}')
		</jsp:text>
	  </og:query>
	</og:equals>
</og:equals>

<!-- リムーブ時は、特定のタスク名称で削除します。 -->
<og:equals val1="{@CMD}" val2="REMOVE" >
	<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	  <jsp:text>
		DELETE FROM GE12
			WHERE SYSTEM_ID = 'GE'
			AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_{@NAME_JA}'
			AND   FGJ = '1'
			AND   CONTXT_PATH = '{@SYS.HOST_URL}'
	  </jsp:text>
	</og:query>
</og:equals>
<br/>
<og:link gamenId="GE0007" keys="command,SYSTEM_ID,PARAM_ID" vals="NEW,GE,CONTEXT_INITIAL_CALL_URL_" target="CONTENTS" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
