/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.octavia.LoadBalancerV2Service;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.octavia.LoadBalancerV2;
import org.openstack4j.model.octavia.LoadBalancerV2Stats;
import org.openstack4j.model.octavia.LoadBalancerV2StatusTree;
import org.openstack4j.model.octavia.LoadBalancerV2Update;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.octavia.domain.LoadBalancerV2StatusTree.OctaviaLoadBalancerV2StatusTree;
import org.openstack4j.openstack.octavia.domain.OctaviaLoadBalancerV2;
import org.openstack4j.openstack.octavia.domain.OctaviaLoadBalancerV2Stats;
import org.openstack4j.openstack.octavia.internal.BaseOctaviaServices;

public class LoadBalancerV2ServiceImpl
extends BaseOctaviaServices
implements LoadBalancerV2Service {
    @Override
    public List<? extends LoadBalancerV2> list() {
        return this.get(OctaviaLoadBalancerV2.LoadBalancersV2.class, this.uri("/lbaas/loadbalancers", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends LoadBalancerV2> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<OctaviaLoadBalancerV2.LoadBalancersV2> req = this.get(OctaviaLoadBalancerV2.LoadBalancersV2.class, this.uri("/lbaas/loadbalancers", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public LoadBalancerV2 get(String loadbalancerId) {
        Preconditions.checkNotNull((Object)loadbalancerId);
        return this.get(OctaviaLoadBalancerV2.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).execute();
    }

    @Override
    public LoadBalancerV2 create(LoadBalancerV2 loadbalancer) {
        Preconditions.checkNotNull((Object)loadbalancer);
        return this.post(OctaviaLoadBalancerV2.class, this.uri("/lbaas/loadbalancers", new Object[0])).entity(loadbalancer).execute();
    }

    @Override
    public LoadBalancerV2 update(String loadbalancerId, LoadBalancerV2Update loadbalancer) {
        Preconditions.checkNotNull((Object)loadbalancerId);
        Preconditions.checkNotNull((Object)loadbalancer);
        return this.put(OctaviaLoadBalancerV2.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).entity(loadbalancer).execute();
    }

    @Override
    public ActionResponse delete(String loadbalancerId) {
        Preconditions.checkNotNull((Object)loadbalancerId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lbaas/loadbalancers/%s", loadbalancerId)).executeWithResponse());
    }

    @Override
    public LoadBalancerV2Stats stats(String loadbalancerId) {
        Preconditions.checkNotNull((Object)loadbalancerId);
        return this.get(OctaviaLoadBalancerV2Stats.class, this.uri("/lbaas/loadbalancers/%s/stats", loadbalancerId)).execute();
    }

    @Override
    public LoadBalancerV2StatusTree statusTree(String loadbalancerId) {
        Preconditions.checkNotNull((Object)loadbalancerId);
        return this.get(OctaviaLoadBalancerV2StatusTree.class, this.uri("/lbaas/loadbalancers/%s/status", loadbalancerId)).execute();
    }
}

