<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="TBLSYU"    select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="DYSET"     select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <TBLSYU    ><xsl:value-of select="$TBLSYU"    /></TBLSYU>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
	 <DYSET		><xsl:value-of select="$DYSET"     /></DYSET>
	 <PGSET		>DOC18</PGSET>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:submit"  />
  </xsl:template>

  <xsl:template match="og:submit">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"  /></TAGNAME>
       <TO_GAMENID><xsl:value-of select="@gamenId" /></TO_GAMENID>
       <HREF      ><xsl:value-of select="@value"   /></HREF>
       <TARGET    ><xsl:value-of select="@target"  /></TARGET>
       <P_KEYS    ><xsl:value-of select="@keys"    /></P_KEYS>
       <P_VALS    ><xsl:value-of select="@vals"    /></P_VALS>
       <COMMAND   ><xsl:value-of select="@command" /></COMMAND>
       <LBLCD     ><xsl:value-of select="@lbl"     /></LBLCD>
       <MSGCD     ><xsl:value-of select="@msg"     /></MSGCD>
       <ONCLICK   ><xsl:value-of select="@onClick" /></ONCLICK>
       <ROLES     ><xsl:value-of select="@roles"   /></ROLES>
     </ROW>
  </xsl:template>

</xsl:stylesheet>
