/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.StringUtil;

public class TableModelHelper {
    private int nowRowNo = -1;
    private boolean isColSkip;
    private boolean isNowName;
    private boolean isReadBreak;
    private String nullBreakClm;
    private String nullSkipClm;
    private int skipRowCnt;
    private int nBrkClmNo = -1;
    private int nSkpClmNo = -1;
    private int clmSize = -1;
    private String[] names;
    private String[] vals;
    private boolean useVals;
    private List<Integer> colList;
    private List<String> nmsList;
    private ConstData cnstData;
    private boolean useDebug;

    public boolean startFile(File file) {
        if (this.useDebug) {
            System.out.println("startFile=[" + file + "]");
        }
        if (this.cnstData != null) {
            this.cnstData.putConstFile(file);
        }
        return true;
    }

    public void endFile(File file) {
        if (this.useDebug) {
            System.out.println("endFile=[" + file + "]");
        }
        this.isReadBreak = false;
        this.endRow();
        if (this.cnstData != null) {
            this.cnstData.clearValsMap(1);
        }
    }

    public boolean startSheet(String string, int n) {
        if (this.useDebug) {
            System.out.println("startSheet=[" + string + "], No=[" + n + "]");
        }
        if (this.cnstData != null) {
            this.cnstData.putConstSheet(string);
        }
        return true;
    }

    public void endSheet(int n) {
        if (this.useDebug) {
            System.out.println("endSheet No=[" + n + "]");
        }
        this.isReadBreak = false;
        this.endRow();
        if (this.cnstData != null) {
            this.cnstData.clearValsMap(2);
        }
    }

    protected void value(String string, int n, char c) {
        this.nowRowNo = n;
        if (string != null && !string.isEmpty()) {
            if (string.charAt(0) == '#') {
                if (this.clmSize <= 0 && string.length() >= 5 && "#NAME".equalsIgnoreCase(string.substring(0, 5))) {
                    this.colList = new ArrayList<Integer>();
                    this.nmsList = new ArrayList<String>();
                    String[] stringArray = StringUtil.csv2Array(string, c);
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string2 = stringArray[i];
                        if (string2 == null || string2.isEmpty()) continue;
                        this.colList.add(i);
                        this.nmsList.add(string2);
                    }
                    this.isNowName = true;
                }
            } else if (this.clmSize > 0 && this.skipRowCnt <= n) {
                String[] stringArray = StringUtil.csv2Array(string, c);
                for (int i = 0; i < this.clmSize; ++i) {
                    int n2 = this.colList.get(i);
                    if (n2 < 0 || n2 >= stringArray.length) continue;
                    this.vals[i] = StringUtil.csvOutQuote(stringArray[n2]);
                }
                this.useVals = true;
            }
            this.endRow();
        }
    }

    protected boolean value(String string, int n, int n2) {
        if (string != null && string.length() > 0) {
            int n3;
            if (this.nowRowNo != n) {
                this.endRow();
                this.nowRowNo = n;
            }
            if (this.cnstData != null) {
                this.cnstData.putConstValue(string, n, n2);
            }
            if (n2 == 0 && string.charAt(0) == '#') {
                if ("#NAME".equalsIgnoreCase(string) && this.clmSize <= 0) {
                    this.isNowName = true;
                    this.colList = new ArrayList<Integer>();
                    this.nmsList = new ArrayList<String>();
                }
                this.isColSkip = !this.isNowName;
            } else if (this.isNowName) {
                this.colList.add(n2);
                this.nmsList.add(string);
            } else if (this.nSkpClmNo >= 0 && StringUtil.isNull(this.vals[this.nSkpClmNo])) {
                this.isColSkip = true;
            } else if (this.clmSize > 0 && this.skipRowCnt <= n && (n3 = this.colList.indexOf(n2)) >= 0) {
                this.vals[n3] = StringUtil.csvOutQuote(string);
                this.useVals = true;
            }
        }
        return !this.isColSkip;
    }

    protected boolean isSkip(int n) {
        return this.isColSkip && this.nowRowNo == n || this.isReadBreak;
    }

    private void endRow() {
        if (this.isNowName) {
            int n;
            this.clmSize = this.colList.size();
            this.names = this.nmsList.toArray(new String[this.clmSize]);
            if (this.nullBreakClm != null) {
                for (n = 0; n < this.clmSize; ++n) {
                    if (!this.nullBreakClm.equalsIgnoreCase(this.names[n])) continue;
                    this.nBrkClmNo = n;
                    break;
                }
            }
            if (this.nullSkipClm != null) {
                for (n = 0; n < this.clmSize; ++n) {
                    if (!this.nullSkipClm.equalsIgnoreCase(this.names[n])) continue;
                    this.nSkpClmNo = n;
                    break;
                }
            }
            if (this.cnstData != null) {
                this.cnstData.setColumns(this.names);
            }
            this.columnNames((String[])this.names.clone());
            this.isNowName = false;
            this.nmsList = null;
        } else if (this.useVals) {
            if (this.nBrkClmNo >= 0 && StringUtil.isNull(this.vals[this.nBrkClmNo])) {
                this.isReadBreak = true;
            } else {
                if (this.cnstData != null) {
                    this.vals = this.cnstData.getConstVals(this.vals);
                }
                this.values(this.vals, this.nowRowNo);
            }
        }
        if (this.clmSize > 0) {
            this.vals = new String[this.clmSize];
        }
        this.isColSkip = false;
        this.useVals = false;
    }

    public void sheetSize(int n) {
        if (this.useDebug) {
            System.out.println("sheetSize=[" + n + "]");
        }
    }

    public void columnNames(String[] stringArray) {
        if (this.useDebug) {
            System.out.println("columnNames=[" + Arrays.toString(stringArray) + "]");
        }
    }

    public void values(String[] stringArray, int n) {
        if (this.useDebug) {
            System.out.println("values[" + n + "]=[" + Arrays.toString(stringArray) + "]");
        }
    }

    public void setNames(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            if (this.useDebug) {
                System.out.println("setNames=[" + string + "]");
            }
            this.colList = new ArrayList<Integer>();
            this.nmsList = new ArrayList<String>();
            String[] stringArray = StringUtil.csv2Array(string);
            int n = bl ? 1 : 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0) continue;
                this.colList.add(i + n);
                this.nmsList.add(string2);
            }
            this.isNowName = true;
            this.useVals = false;
            this.endRow();
        }
    }

    public boolean isNameSet() {
        return this.clmSize > 0;
    }

    public void setReadBreak(boolean bl) {
        this.isReadBreak = bl;
    }

    public void setSkipRowCount(int n) {
        this.skipRowCnt = n;
    }

    public void setNullBreakClm(String string) {
        this.nullBreakClm = string;
    }

    public void setNullSkipClm(String string) {
        this.nullSkipClm = string;
    }

    public void setConstData(String string, String string2) {
        if (string != null && !string.isEmpty() && string2 != null && !string2.isEmpty()) {
            this.cnstData = new ConstData(string, string2);
            if (this.names != null) {
                this.cnstData.setColumns(this.names);
            }
        }
    }

    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    protected boolean isDebug() {
        return this.useDebug;
    }

    private static final class ConstData {
        public static final int END_FILE = 1;
        public static final int END_SHEET = 2;
        private static final String KEYS = ",SHEET,FILE,NAME,SUFIX,";
        private final Map<String, String> cnstMap = new HashMap<String, String>();
        private final Map<String, Integer> rowcolMap = new HashMap<String, Integer>();
        private final Map<Integer, String> valsMap = new HashMap<Integer, String>();
        private int maxRow = -1;
        private boolean isNameSet;
        private File tmpFile;
        private String tmpShtNm;

        ConstData(String string, String string2) {
            String[] stringArray = string.split(",");
            String[] stringArray2 = string2.split(",");
            if (stringArray.length != stringArray2.length) {
                String string3 = "\u30ad\u30fc\u306b\u5bfe\u3059\u308b\u30a2\u30c9\u30ec\u30b9\u306e\u500b\u6570\u304c\u4e0d\u4e00\u81f4\u3067\u3059\u3002Keys=[" + string + "]" + " , Adrs=[" + string2 + "]";
                throw new RuntimeException(string3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string4;
                String string5 = stringArray[i].trim();
                if (string5.isEmpty() || (string4 = stringArray2[i].trim()).isEmpty()) continue;
                int n2 = string4.indexOf(45);
                if (n2 > 0) {
                    n = Integer.parseInt(string4.substring(0, n2));
                    if (this.maxRow < n) {
                        this.maxRow = n;
                    }
                } else if (!KEYS.contains(',' + string4 + ',')) {
                    n = Integer.parseInt(string4.substring(1)) - 1;
                    int n3 = string4.charAt(0) - 65;
                    if (this.maxRow < n) {
                        this.maxRow = n;
                    }
                    string4 = n + "-" + n3;
                }
                this.cnstMap.put(string5, string4);
            }
        }

        void setColumns(String ... stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = this.cnstMap.get(stringArray[i]);
                    if (string == null) continue;
                    this.rowcolMap.put(string, i);
                }
                this.isNameSet = true;
                if (this.tmpFile != null) {
                    this.putConstFile(this.tmpFile);
                }
                if (this.tmpShtNm != null) {
                    this.putConstSheet(this.tmpShtNm);
                }
            }
        }

        void putConstValue(String string, int n, int n2) {
            String string2;
            Integer n3;
            if (n <= this.maxRow && (n3 = this.rowcolMap.get(string2 = n + "-" + n2)) != null) {
                this.valsMap.put(n3, string);
            }
        }

        void putConstFile(File file) {
            if (file != null) {
                this.tmpFile = file;
                if (this.isNameSet) {
                    FileInfo fileInfo = new FileInfo(file);
                    for (String string : FileInfo.KEYS) {
                        String string2;
                        Integer n = this.rowcolMap.get(string);
                        if (n == null || (string2 = fileInfo.getValue(string)) == null) continue;
                        this.valsMap.put(n, string2);
                    }
                }
            }
        }

        void putConstSheet(String string) {
            if (string != null) {
                Integer n;
                this.tmpShtNm = string;
                if (this.isNameSet && (n = this.rowcolMap.get("SHEET")) != null) {
                    this.valsMap.put(n, string);
                }
            }
        }

        void clearValsMap(int n) {
            this.valsMap.clear();
            if (n == 2) {
                this.putConstFile(this.tmpFile);
            }
        }

        String[] getConstVals(String[] stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                for (Map.Entry<Integer, String> entry : this.valsMap.entrySet()) {
                    int n = entry.getKey();
                    String string = entry.getValue();
                    if (n >= stringArray.length) continue;
                    stringArray[n] = string;
                }
            }
            return stringArray;
        }
    }
}

