/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiVersion {
    private static final Logger logger = LoggerFactory.getLogger(ApiVersion.class);
    private static final String API_VERSION_FILEPATH = "oracle/cloudstorage/api/api-version.txt";
    private static String apiVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getApiVersion() {
        if (apiVersion != null) {
            return apiVersion;
        }
        Class<ApiVersion> clazz = ApiVersion.class;
        synchronized (ApiVersion.class) {
            if (apiVersion != null) return apiVersion;
            Properties prop = new Properties();
            ClassLoader cl = ApiVersion.class.getClassLoader();
            InputStream input = null;
            try {
                input = cl.getResourceAsStream(API_VERSION_FILEPATH);
                prop.load(input);
                apiVersion = prop.getProperty("version");
                if (apiVersion == null) {
                    apiVersion = "";
                }
                logger.info("Low Level API version: " + apiVersion.toString());
                String string = apiVersion;
                // ** MonitorExit[var0] (shouldn't be in output)
                return string;
            }
            catch (IOException ex) {
                logger.trace(ex.getMessage());
                logger.info("Unable to get API version.");
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        logger.trace(e.getMessage());
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return apiVersion;
        }
    }
}

