/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.stripe;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import oracle.cloudstorage.text.Strings;
import oracle.cloudstorage.util.Throwables;

public class JoiningInputStream
extends InputStream {
    private final int width;
    private final InputStream[] sources;
    private final PipedOutputStream[] buffers;
    private final PipedInputStream[] pipes;
    private final boolean[] pipesClosed;
    private int numBytesRemainingInSegment = -1;
    private int index = 0;
    private final List<Future<String>> futureMd5s;
    private IOException sourceReadException = null;
    private final Object sourceReadExceptionLock = new Object();
    private final ExecutorService executor;

    public JoiningInputStream(ExecutorService executor, int stripeSegmentWidth, InputStream ... stripeSegments) throws IOException {
        this(executor, stripeSegmentWidth, stripeSegmentWidth, stripeSegments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoiningInputStream(ExecutorService executor, int stripeSegmentWidth, int pipeSize, InputStream ... stripeSegments) throws IOException {
        JoiningInputStream joiningInputStream = this;
        synchronized (joiningInputStream) {
            this.executor = executor;
            this.width = stripeSegmentWidth;
            this.numBytesRemainingInSegment = stripeSegmentWidth;
            this.sources = stripeSegments;
            this.buffers = new PipedOutputStream[stripeSegments.length];
            this.pipes = new PipedInputStream[stripeSegments.length];
            this.pipesClosed = new boolean[stripeSegments.length];
            this.futureMd5s = new ArrayList<Future<String>>(stripeSegments.length);
            for (int i = 0; i < stripeSegments.length; ++i) {
                this.buffers[i] = new PipedOutputStream();
                this.pipes[i] = new PipedInputStream(this.buffers[i], pipeSize);
                this.pipesClosed[i] = false;
            }
        }
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes, 0, 1);
        return read < 0 ? read : bytes[0];
    }

    @Override
    public synchronized int read(byte[] bytes, int off, int len) throws IOException {
        if (this.futureMd5s.isEmpty()) {
            this.readSources();
        }
        int remainingInRequest = len;
        int currentOffset = off;
        int totalRead = -1;
        while (remainingInRequest > 0) {
            int pipeRead;
            this.throwSourceReadException();
            int remaining = Math.min(remainingInRequest, this.numBytesRemainingInSegment);
            int n = pipeRead = this.pipesClosed[this.index] ? -1 : this.pipes[this.index].read(bytes, currentOffset, remaining);
            if (pipeRead < 0) {
                this.closePipeBeingRead();
            } else {
                totalRead += (totalRead < 0 ? 1 : 0) + pipeRead;
                currentOffset += pipeRead;
                remainingInRequest -= pipeRead;
                this.numBytesRemainingInSegment -= pipeRead;
            }
            if (this.updatePipe(pipeRead)) continue;
            break;
        }
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.sources.length; ++i) {
            this.sources[i].close();
            this.buffers[i].close();
            this.pipes[i].close();
        }
    }

    public String getMd5(int stripeSegmentIndex) throws InterruptedException, ExecutionException {
        String md5 = this.futureMd5s.get(stripeSegmentIndex).get();
        return md5;
    }

    private void readSources() {
        for (int i = 0; i < this.sources.length; ++i) {
            Future<String> futureMd5 = this.executor.submit(this.sourceReader(i));
            this.futureMd5s.add(futureMd5);
        }
    }

    private Callable<String> sourceReader(final int i) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return JoiningInputStream.this.readSource(i);
            }
        };
    }

    private String readSource(int i) throws Exception {
        Throwable ct;
        String string;
        byte[] bytes = new byte[this.width];
        int read = -1;
        long totalRead = 0L;
        InputStream source = null;
        PipedOutputStream buffer = null;
        Exception t = null;
        try {
            String md5;
            source = this.sources[i];
            buffer = this.buffers[i];
            MessageDigest md5er = MessageDigest.getInstance("MD5");
            do {
                if ((read = source.read(bytes, 0, bytes.length)) < 0) continue;
                ((OutputStream)buffer).write(bytes, 0, read);
                md5er.update(bytes, 0, read);
                totalRead += (long)read;
            } while (read >= 0);
            ((OutputStream)buffer).flush();
            string = md5 = Strings.toHex(md5er.digest());
            ct = null;
        }
        catch (Exception e) {
            try {
                this.handleSourceReadException(i, totalRead, e);
                t = e;
                throw e;
            }
            catch (Throwable throwable) {
                Throwable ct2 = null;
                for (Closeable c : new Closeable[]{source, buffer}) {
                    if (c == null) continue;
                    try {
                        c.close();
                    }
                    catch (Throwable e2) {
                        if (ct2 == null) {
                            ct2 = e2;
                            continue;
                        }
                        Throwables.addSuppressed(ct2, e2);
                    }
                }
                if (ct2 != null) {
                    if (t == null) {
                        throw new RuntimeException(ct2);
                    }
                    Throwables.addSuppressed(t, ct2);
                }
                throw throwable;
            }
        }
        for (Closeable c : new Closeable[]{source, buffer}) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable e) {
                if (ct == null) {
                    ct = e;
                    continue;
                }
                Throwables.addSuppressed(ct, e);
            }
        }
        if (ct != null) {
            if (t == null) {
                throw new RuntimeException(ct);
            }
            Throwables.addSuppressed(t, ct);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSourceReadException(int segment, long bytesRead, Exception cause) {
        String message = "Exception thrown reading stripe segment " + segment + " after reading " + bytesRead + " bytes.";
        IOException detailedException = new IOException(message, cause);
        Object object = this.sourceReadExceptionLock;
        synchronized (object) {
            if (this.sourceReadException == null) {
                this.sourceReadException = detailedException;
            } else {
                Throwables.addSuppressed(this.sourceReadException, detailedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwSourceReadException() throws IOException {
        Object object = this.sourceReadExceptionLock;
        synchronized (object) {
            if (this.sourceReadException != null) {
                throw this.sourceReadException;
            }
        }
    }

    private void closePipeBeingRead() throws IOException {
        if (this.pipesClosed[this.index]) {
            return;
        }
        this.pipes[this.index].close();
        this.pipesClosed[this.index] = true;
    }

    private boolean updatePipe(int read) {
        if (this.numBytesRemainingInSegment > 0 && read > 0) {
            return true;
        }
        if (this.numBytesRemainingInSegment < 0) {
            throw new IllegalStateException("Read too many bytes from stripe segment. Segment " + this.index + " was over-read by " + -this.numBytesRemainingInSegment + " bytes.");
        }
        this.numBytesRemainingInSegment = this.width;
        for (int count = 0; count < this.pipes.length; ++count) {
            if (++this.index >= this.pipes.length) {
                this.index = 0;
            }
            if (this.pipesClosed[this.index]) continue;
            return true;
        }
        return false;
    }
}

