/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.Comparator;
import oracle.cloudstorage.api.retry.CompositeRetry;
import oracle.cloudstorage.api.retry.IRetryStrategy;

public abstract class PrioritizedRetryStrategy
implements IRetryStrategy {
    public static final int DEFAULT = 0;
    public static final int HIGH = 1000;
    private int priority = 0;

    public PrioritizedRetryStrategy() {
        this(0);
    }

    public PrioritizedRetryStrategy(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public static <P extends PrioritizedRetryStrategy> CompositeRetry<P> of(P ... parts) {
        Comparator comparator = PrioritizedRetryStrategy.comparator();
        CompositeRetry compositeRetry = new CompositeRetry(comparator, parts);
        return compositeRetry;
    }

    public static <C extends PrioritizedRetryStrategy> Comparator<C> comparator() {
        Comparator comparator = new Comparator<C>(){

            @Override
            public int compare(C retryStrategy0, C retryStrategy1) {
                int priority1;
                int priority0 = retryStrategy0 == null ? Integer.MIN_VALUE : ((PrioritizedRetryStrategy)retryStrategy0).getPriority();
                int n = priority1 = retryStrategy1 == null ? Integer.MIN_VALUE : ((PrioritizedRetryStrategy)retryStrategy1).getPriority();
                return priority1 < priority0 ? -1 : (priority1 > priority0 ? 1 : 0);
            }
        };
        return comparator;
    }
}

