/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.retry.Backoff;

public class ExponentialBackoff
extends Backoff {
    private static final int DEFAULT_BASE = 2;

    public ExponentialBackoff() {
        this(true);
    }

    public ExponentialBackoff(boolean useAttempt) {
        this(2.0, useAttempt);
    }

    public ExponentialBackoff(double base) {
        this(base, true);
    }

    public ExponentialBackoff(double base, boolean useAttempt) {
        this(500L, TimeUnit.MILLISECONDS, base, useAttempt);
    }

    public ExponentialBackoff(long initialDelay, TimeUnit units) {
        this(initialDelay, units, true);
    }

    public ExponentialBackoff(long initialDelay, TimeUnit units, boolean useAttempt) {
        this(initialDelay, units, 2.0, useAttempt);
    }

    public ExponentialBackoff(long initialDelay, TimeUnit units, double base) {
        super(initialDelay, units, base, true);
    }

    public ExponentialBackoff(long initialDelay, TimeUnit units, double base, boolean useAttempt) {
        super(initialDelay, units, base, useAttempt);
    }

    @Override
    protected long calculateMultiplier(int iteration) {
        long multiplier = (long)Math.pow(this.getBase(), iteration);
        return multiplier;
    }
}

