/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.header;

import java.util.HashSet;
import java.util.Set;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.IHeaderWriter;
import oracle.cloudstorage.api.header.Provider;
import oracle.cloudstorage.api.request.AttributetMap;

public class Map
extends AttributetMap<Provider, Header>
implements IHeaderWriter {
    private static final long serialVersionUID = -7332067060922457385L;
    private static final Set<String> maskedKeys = new HashSet<String>();

    static void addMaskedKey(String key) {
        maskedKeys.add(key.toLowerCase());
    }

    public Map() {
    }

    public Map(java.util.Map<? extends String, ?> source) {
        super(source);
    }

    public static String mask(String key, Object value) {
        boolean mask = maskedKeys.contains(key.toLowerCase());
        String maskedValue = value == null ? null : (mask ? "<" + key + "-value>" : value.toString());
        return maskedValue;
    }

    @Override
    public String mask(String key) {
        String value = this.get(key);
        String maskedValue = Map.mask(key, value);
        return maskedValue;
    }

    @Override
    public Map getHeaders() {
        return this;
    }

    @Override
    public String getHeader(String key) {
        return this.get(key);
    }

    @Override
    public String getHeader(Header header) {
        return this.get(header);
    }

    @Override
    public void setHeader(Provider value) {
        this.put(value);
    }

    @Override
    public void clearHeaders() {
        this.clear();
    }
}

