/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.AuthResponseAdapter;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.request.RequestContext;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.api.request.processor.RequestProcessor;
import oracle.cloudstorage.api.retry.RetryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public abstract class AuthStrategy
extends RequestProcessor<IAuthRequestBuilder, IAuthReply, AuthResponseAdapter>
implements IAuthStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AuthStrategy.class);
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final String DEFAULT_SERVICE_NAME = "Storage";
    public static final String DEFAULT_USER_NAME = "Storageadmin";
    public static final String OCS_URL_PREFIX = "https://storage.";
    public static final String OCS_URL_SUFFIX = ".oraclecloud.com";
    public static final String OCS_URL_PATH = "auth/v1.0";
    public static final char SERVICE_NAME_SEP = '-';
    public static final char ACCOUNT_SEP = ':';
    private final Object lock = new Object();
    private volatile long timeout = 0L;
    private volatile Thread currentAuthenticator = null;
    protected IAuthReply reply = null;
    private RequestContext<IAuthRequestBuilder, ? extends IAuthStrategy> context;
    private ISender requestor;

    @Override
    public ISendable getSendable() {
        return this.getBuilder().getSendable();
    }

    @Override
    public RequestContext<IAuthRequestBuilder, ? extends IAuthStrategy> getContext() {
        return this.context;
    }

    @Override
    public void setRequestor(ISender requestor) {
        this.requestor = requestor;
    }

    @Override
    public IResponse send(Logger logger, Marker marker, ISendable request) {
        IResponse response = this.requestor == null ? this.getSession().send(logger, marker, request) : this.requestor.send(logger, marker, request);
        return response;
    }

    @Override
    public void setContext(RequestContext<IAuthRequestBuilder, ? extends IAuthStrategy> context) {
        this.context = context;
    }

    @Override
    public IAuthRequestBuilder getBuilder() {
        return this.context.getBuilder();
    }

    protected ISession getSession() {
        ISession session = this.getContext() == null ? null : this.getContext().getSession();
        return session;
    }

    @Override
    public IAuthReply authenticate(IAuthRequestBuilder authRequestBuilder, IAuthReply previousReply) throws RetryException, InterruptedException {
        long invocationTime = System.currentTimeMillis();
        Thread authenticator = this.getAuthenticator(invocationTime);
        if (authenticator == null) {
            this.executeRequestAndClearAuthenticator(authRequestBuilder, previousReply);
        } else {
            this.waitForAuthenticator(authenticator, invocationTime);
        }
        return this.reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getAuthenticator(long invocationTime) {
        Object object = this.lock;
        synchronized (object) {
            if (invocationTime > this.timeout) {
                logger.debug("Authentication required.");
                if (this.currentAuthenticator != null) {
                    logger.warn("Authenticator {} timed out at {}.", (Object)this.currentAuthenticator, (Object)this.timeout);
                }
                this.timeout = invocationTime + TIMEOUT;
                this.currentAuthenticator = Thread.currentThread();
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication starting, setting timeout to {}.", (Object)this.timeout);
                return null;
            }
            logger.debug("Authenticator {} in progress.", (Object)this.currentAuthenticator);
            return this.currentAuthenticator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestAndClearAuthenticator(IAuthRequestBuilder authRequestBuilder, IAuthReply previousReply) throws RetryException, InterruptedException {
        try {
            if (previousReply != null && previousReply.isOlderThan(this.reply)) {
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication requested because of stale {}.  Returning current {}.", (Object)previousReply, (Object)this.reply);
            } else {
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication executing storage request.");
                ISession session = this.getSession();
                session.initKeepAlive(authRequestBuilder);
                this.reply = (IAuthReply)this.execute(authRequestBuilder);
                if (this.reply.isSuccessful()) {
                    if (this.reply.getContext() != null && this.reply.getContext().getRetryState() != null) {
                        this.reply.getContext().getRetryState().setAuthReply(null);
                    }
                } else {
                    logger.warn(oracle.cloudstorage.text.Marker.auth.marker, "Authentication unsuccessful: {}", (Object)this.reply);
                }
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication complete: {}", (Object)this.reply);
            }
        }
        finally {
            long t = this.timeout;
            logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication timeout {} about to be cleared.  {}", (Object)t, (Object)this.reply);
            Object object = this.lock;
            synchronized (object) {
                if (Thread.currentThread() == this.currentAuthenticator) {
                    logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication acquired lock to clear timeout and notifyAll.");
                    this.timeout = 0L;
                    this.currentAuthenticator = null;
                    this.lock.notifyAll();
                } else {
                    logger.debug("Authenticator updated to {}, {} will not clear authenticator and timeout.", (Object)this.currentAuthenticator, (Object)Thread.currentThread());
                }
            }
            logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication timeout {} cleared.  {}", (Object)t, (Object)this.reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAuthenticator(Thread authenticator, long now) throws InterruptedException {
        long remaining = 0L;
        while ((remaining = this.timeout - System.currentTimeMillis()) > 0L) {
            logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authenticator {} already in progress.  Waiting up to {} ms.", (Object)authenticator, (Object)remaining);
            Object object = this.lock;
            synchronized (object) {
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authentication acquired lock to wait for authenticator {}.", (Object)authenticator);
                remaining = this.timeout - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.lock.wait(remaining);
                } else {
                    logger.debug("Authenticator {} cleared timeout and notifiedAll() while acquiring lock to wait.", (Object)authenticator);
                }
            }
        }
        long duration = System.currentTimeMillis() - now;
        logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Authenticator {} complete after {} ms: {}", authenticator, duration, this.reply);
        if (duration >= TIMEOUT) {
            logger.warn("Authentication timed out waiting for notification from authenticator {}.", (Object)authenticator);
        }
    }

    @Override
    public IAuthReply getReply() {
        return this.reply;
    }

    @Override
    public boolean isAuthenticating() {
        return this.timeout > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForAuth() throws InterruptedException {
        boolean waited = false;
        while (this.reply == null) {
            if (!waited) {
                logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Waiting for authentication.");
                waited = true;
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(TimeUnit.SECONDS.toMillis(1L));
                }
                catch (InterruptedException e) {
                    logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Waiting for authentication interrupted", e);
                    throw e;
                }
            }
        }
        if (waited) {
            logger.debug(oracle.cloudstorage.text.Marker.auth.marker, "Waited for authentication: {}", (Object)this.reply);
        }
    }

    @Override
    public String buildStorageUser(String account, String userName) {
        String user = account + ':' + userName;
        return user;
    }

    @Override
    public String buildStorageUser(String tenant) {
        return tenant == null ? null : this.buildStorageUser(DEFAULT_SERVICE_NAME, tenant, DEFAULT_USER_NAME);
    }

    @Override
    public String buildStorageAccount(String serviceName, String identityDomain) {
        String account = serviceName + '-' + identityDomain;
        return account;
    }

    @Override
    public String buildStorageUser(String serviceName, String identityDomain, String userName) {
        String account = this.buildStorageAccount(serviceName, identityDomain);
        String user = this.buildStorageUser(account, userName);
        return user;
    }

    @Override
    public String buildHost(String region) {
        String url = OCS_URL_PREFIX + region + OCS_URL_SUFFIX;
        return url;
    }

    @Override
    protected abstract AuthResponseAdapter doExecute(IAuthRequestBuilder var1);
}

