/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.common.payloads;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openstack4j.model.common.Payload;

public class FilePayload
implements Payload<File> {
    private File file;
    private InputStream is;

    public FilePayload(File file) {
        this.file = file;
    }

    @Override
    public InputStream open() {
        try {
            this.is = new FileInputStream(this.file);
            return this.is;
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public File getRaw() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    @Override
    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

