/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.report;

import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.ResourceManager;

import java.io.File;

/**
 * DBTableModel インターフェース のオブジェクトを雛型ファイルに適用して レポートを作成する為の，共通インターフェースです。
 *
 * @og.group 帳票システム
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface DBTableReport {

	/**
	 * DBTableModel から 各形式のデータを作成して,PrintWriter に書き出します。
	 *
	 */
	void writeReport() ;

	/**
	 * 雛型ファイル名をセットします。
	 *
	 * @og.rev 3.6.0.0 (2004/09/17) メソッド名の変更。setInputFile ⇒ setTemplateFile
	 * @og.rev 3.8.0.0 (2005/06/07) 引数を String  ⇒ File に変更
	 *
	 * @param   inFile 雛型ファイル名
	 */
	void setTemplateFile( File inFile ) ;

	/**
	 * 最初のページのみに使用する雛型ファイル名をセットします。
	 *
	 * @og.rev 3.6.0.0 (2004/09/17) 新規追加
	 * @og.rev 3.8.0.0 (2005/06/07) 引数を String  ⇒ File に変更
	 *
	 * @param   inFile 最初のページの雛型ファイル名
	 */
	void setFirstTemplateFile( File inFile ) ;

	/**
	 * 変換後ファイルを出力するディレクトリ名をセットします。
	 *
	 * @param   outDir 出力ディレクトリ名
	 */
	void setOutputDir( String outDir ) ;

	/**
	 * 変換後ファイルキーをセットします。
	 * キーとは、拡張子の無い状態までのファイル名です。
	 * 変換後ファイルは、複数発生します。
	 * 実際に出力されるファイル名は、outFile + "_連番.html" となります。
	 *
	 * @param   outFile 出力ファイル名の共通部
	 */
	void setOutputFileKey( String outFile ) ;

	/**
	 * 帳票起動された要求番号をセットします。
	 *
	 * @og.rev 3.8.5.1 (2006/04/28) 新規追加
	 *
	 * @param   ykno 要求番号
	 */
	void setYkno( String ykno ) ;

	/**
	 * DBTableModel をセットします。
	 *
	 * @param	table	DBTableModelオブジェクト
	 */
	void setDBTableModel( DBTableModel table ) ;

	/**
	 * 固定部の key 部分を指定します。
	 * カンマで複数指定できます。
	 *
	 * @param   headerKeys 固定部のキー配列(可変長引数)
	 */
	void setHeaderKeys( String... headerKeys ) ;

	/**
	 * 固定部のkey に対応する値を指定します。
	 * カンマで複数指定で、リクエスト情報でも設定できます。
	 *
	 * @param   headerVals 固定部の値配列(可変長引数)
	 */
	void setHeaderVals( String... headerVals ) ;

	/**
	 * 繰り返し部の終了後に表示する key 部分を指定します。
	 * カンマで複数指定できます。
	 *
	 * @param   footerKeys 繰り返し部の終了後に表示するキー配列(可変長引数)
	 */
	void setFooterKeys( String... footerKeys ) ;

	/**
	 * 固定部のkey に対応する値を指定します。
	 * カンマで複数指定で、リクエスト情報でも設定できます。
	 *
	 * @param   footerVals 繰り返し部の終了後に表示する値配列(可変長引数)
	 */
	void setFooterVals( String... footerVals ) ;

	/**
	 * ボディー部(繰り返し部)がなくなったときに、それ以降を表示するかどうかを指定します。
	 * true では、それ以降を出力しません。
	 * デフォルト "true" (なくなった時点で、出力しない。)です。
	 *
	 * @param   pageEndCut 繰り返し部の終了後に継続処理するかどうか (true:処理しない/false:処理する)
	 */
	void setPageEndCut( boolean pageEndCut ) ;

	/**
	 * リソースマネージャーをセットします。
	 * これは、言語(ロケール)に応じた DBColumn をあらかじめ設定しておく為に
	 * 必要です。
	 * リソースマネージャーが設定されていない、または、所定のキーの DBColumn が
	 * リソースに存在しない場合は、内部で DBColumn オブジェクトを作成します。
	 *
	 * @og.rev 4.0.0.0 (2005/01/31) lang ⇒ ResourceManager へ変更
	 *
	 * @param  resource リソースマネージャー
	 */
	void setResourceManager( final ResourceManager resource );

	/**
	 * 帳票ＩＤ をセットします。
	 * この帳票ＩＤを利用して、画像ファイル等のセーブディレクトリを求めます。
	 *
	 * @og.rev 3.6.1.0 (2005/01/05) 新規作成
	 *
	 * @param   listId 帳票ＩＤ
	 */
	void setListId( String listId ) ;
}
