/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package gf;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * 一覧検索:標準(Java) (GF9040) の 業務ロジックです。
 * 
 * 画面で入力された検索条件を元にSQL文を構築します。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class GF9040S extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean check() {
		return must( "SYSTEM_ID" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean logic() {
		String sql = "select " + "SYSTEM_ID, LANG, CLM, NAME_JA, LABEL_NAME, KBSAKU, CDTAN, '1' AS ONMARK " + "from GF41 " + "where FGJ in ('0','1') ";

		if( var( "SYSTEM_ID" ) != null && var( "SYSTEM_ID" ).length() > 0 ) {
			sql += " and SYSTEM_ID = '" + var( "SYSTEM_ID" ) + "'";
		}
		if( var( "LANG" ) != null && var( "LANG" ).length() > 0 ) {
			sql += " and LANG = '" + var( "LANG" ) + "'";
		}
		if( var( "CLM" ) != null && var( "CLM" ).length() > 0 ) {
			sql += " and CLM = '" + var( "CLM" ) + "'";
		}
		if( var( "NAME_JA" ) != null && var( "NAME_JA" ).length() > 0 ) {
			sql += " and NAME_JA like '" + var( "NAME_JA" ) + "'";
		}
		if( var( "LABEL_NAME" ) != null && var( "LABEL_NAME" ).length() > 0 ) {
			sql += " and LABEL_NAME like '" + var( "LABEL_NAME" ) + "'";
		}
		if( var( "KBSAKU" ) != null && var( "KBSAKU" ).length() > 0 ) {
			sql += " and KBSAKU = '" + var( "KBSAKU" ) + "'";
		}

		if( var( "ORDER_BY" ) != null && var( "ORDER_BY" ).length() > 0 ) {
			sql += " order by " + var( "ORDER_BY" );
		}
		else {
			sql += " order by SYSTEM_ID,CLM,LANG ";
		}

		// 戻り値を登録します。
		rtn( sql );

		return true;
	}
}
