var jViewClms = null;
var jSumClms = null;
var jGroupClms = null;
var jSubTotalClms = null;
var jTotalClms = null;
var jOrderByClms = null;
var jDescClms = null;
var jGrandTotalClm = null;

$(function(){
	$.each( $("#clmLayer").find(".clmGroup"), function( idx ) {
		$(this).sortable({
		items		: $(this).find(".sortItem")
		,overlap	: "horizontal"
		,constraint	: "horizontal"
		,stop		:
			function() {
				makeViewClms()
			}
		});
	});

	var checkboxClms = $("input[type=checkbox]");
	jViewClms = checkboxClms.filter("[name^=EDIT_VIEW_]");
	jSumClms = checkboxClms.filter("[name^=EDIT_SUM_]");
	jGroupClms = checkboxClms.filter("[name^=EDIT_GROUP_]");
	jSubTotalClms = checkboxClms.filter("[name^=EDIT_SUBTOTAL_]");
	jTotalClms = checkboxClms.filter("[name^=EDIT_TOTAL_]");
	jOrderByClms = $("input[type=text]").filter("[name^=EDIT_ORDERBY_]");
	jDescClms = checkboxClms.filter("[name^=EDIT_DESC_]");
	jGrandTotalClm = checkboxClms.filter("[name^=EDIT_GRANDTOTAL_]");

	$.each( jSumClms, function() { checkSumClm( $(this) ); } );
	jSumClms.click( function(){ checkSumClm( $(this) ); } );

	$("#groupBtn").click( function() { groupBtn(); } );

	$(checkboxClms).filter("[name=VIEW_ALL_CHECK]").click( function() {
		var checked = $(this).attr("checked");
		jViewClms.attr( "checked", checked ? "checked" : "" );
	});
	
	$(window).resize(function(){ resizeClmLayer();}); // 5.6.0.2 (2013/01/19)
	resizeClmLayer();

	window.focus();
});

/************************************************************************/
/* 集計項目のチェックON/OFFに連動して集計キー、合計キーの				*/
/* チェックボックスのON/OFFを制御します。								*/
/*																		*/
/* @og.rev 5.3.6.0 (2011/06/01) 新規作成								*/
/*																		*/
/************************************************************************/
function checkSumClm( jSumClm ) {
	var clm = jSumClm.attr("name").replace("EDIT_SUM_","");
	// 対象項目がチェックされている場合、集計・合計キーを無効にする
	if( jSumClm.is(":checked") ) {
		jGroupClms.filter("[name=EDIT_GROUP_"+clm+"]").attr("disabled","disabled");
		jSubTotalClms.filter("[name=EDIT_SUBTOTAL_"+clm+"]").attr("disabled","disabled");
		jTotalClms.filter("[name=EDIT_TOTAL_"+clm+"]").attr("disabled","disabled");
	}
	// 対象項目がチェックされていない場合、集計・合計キーを有効にする
	else {
		jGroupClms.filter("[name=EDIT_GROUP_"+clm+"]").removeAttr("disabled");
		jSubTotalClms.filter("[name=EDIT_SUBTOTAL_"+clm+"]").removeAttr("disabled");
		jTotalClms.filter("[name=EDIT_TOTAL_"+clm+"]").removeAttr("disabled");
	}
}

/************************************************************************/
/* カラムのD&Dにに連動してhidden項目(viewClms)の値を書き換えます。		*/
/*																		*/
/* @og.rev 5.3.6.0 (2011/06/01) 新規作成								*/
/*																		*/
/************************************************************************/
function makeViewClms() {
	var viewClms = "";
	var groups = $(".clmGroup");
	$.each( groups, function( idx ) {
		if( idx > 0 ) { viewClms += '|' }
		var items = $(this).find(".sortItem");
		$.each( items, function( idx2 ) {
			if( idx2 > 0 ) { viewClms += ',' }
			var clm = $(this).attr("name");
			if( $(this).find("input[name=EDIT_VIEW_"+clm+"][type=checkbox]:checked").length == 0 ) {
				viewClms += '!';
			}
			viewClms += clm; 
		});
	});

	if( viewClms != "" ) {
		$("#viewClms").val( viewClms );
	}
}

/************************************************************************/
/* 集計キー以外の項目を非選択状態にします。								*/
/*																		*/
/* @og.rev 5.3.6.0 (2011/06/01) 新規作成								*/
/*																		*/
/************************************************************************/
function groupBtn() {
	if( jGroupClms.filter(":checked").length > 0 ) {
		$.each( jGroupClms, function() {
			var clm = $(this).attr("name").replace("EDIT_GROUP_","");
			if( !$(this).is(":checked") && !jSumClms.filter("[name=EDIT_SUM_"+clm+"]").is(":checked") ) {
				jViewClms.filter("[name=EDIT_VIEW_"+clm+"]").removeAttr("checked");
				jSubTotalClms.filter("[name=EDIT_SUBTOTAL_"+clm+"]").removeAttr("checked");
				jTotalClms.filter("[name=EDIT_TOTAL_"+clm+"]").removeAttr("checked");
				jOrderByClms.filter("[name=EDIT_ORDERBY_"+clm+"]").val("");
				jDescClms.filter("[name=EDIT_DESC_"+clm+"]").removeAttr("checked");
			}
			else {
				jViewClms.filter("[name=EDIT_VIEW_"+clm+"]").attr("checked","checked");
			}
		});
	}
}

/************************************************************************/
/* 呼び出し元の親Windowを再ロードします。								*/
/*																		*/
/* @og.rev 5.3.6.0 (2011/06/01) 新規作成								*/
/* @og.rev 5.7.9.1 (2014/08/29) GAMENID付加								*/
/* @og.rev 5.9.25.1 (2017/10/13) 3ペイン画面でedit登録					*/
/*																		*/
/************************************************************************/
function refreshEdit( guikey, editName, backAddress ) {
	var opn = top.document.opn;
	
	if( !opn ) {
		if( top.window.opener.parent && top.window.opener.parent.location
			&& top.window.opener.parent.location.href.indexOf( guikey ) >= 0 ) {
//			opn = top.window.opener.parent;
			// 名称がCONTENTSでない場合は一段上も確認する
			if( top.window.opener.parent.name == "CONTENTS" ){
				opn = top.window.opener.parent;
			}
			else if( top.window.opener.parent.parent && top.window.opener.parent.parent.location
				&& top.window.opener.parent.parent.name == "CONTENTS"
				&& top.window.opener.parent.parent.location.href.indexOf( guikey ) >= 0 ) {
					opn = top.window.opener.parent.parent;
			}
			else{
				opn = top.window.opener.parent;
			}
		}
		else {
			opn = top.window.opener;
		}

		top.document.opn = opn;
	}

	if( opn && !opn.closed && opn.location ) {
	//	opn.location.href = backAddress + "?command=RENEW&editName=" +  encodeURIComponent( editName ) + "&clear=true&displayMsg=MSG0065&h_qryFcs=false";
		opn.location.href = backAddress + "?command=RENEW&GAMENID="+ guikey +"&editName=" +  encodeURIComponent( editName ) + "&clear=true&displayMsg=MSG0065&h_qryFcs=false";
	}
}

/************************************************************************/
/* リサイズ時にdiv#clmLayerの横幅を変更（win-160px)します				*/
/*																		*/
/* @og.rev 5.6.0.2 (2013/01/19) 新規作成								*/
/*																		*/
/************************************************************************/
function resizeClmLayer(){
	var newWidth = $(window).width() - 160;
	if( newWidth < 640){ newWidth = 640; };
	$('#clmLayer').css('width', newWidth+'px');
}
