//----------------------------------------------------------
// 左側のフレームを基準に調整する
//----------------------------------------------------------
function adjustLeftFrameWidth() {
	var frame;
	var width;

	// 検索結果部のフレームセットを取得
	frame = getResultFrameSet();
	if (frame == null) {
		return;
	}

	// 左側の調整後フレームサイズを取得
	width = getLeftFrameAjustWidth(55);
	if (width == 0) {
		return;
	}

	// フレームセットの横幅が十分な時
	if (frame.offsetWidth > width) {
		// 左側のフレームに合せて調整する
		frame.cols = width + ",*";
	// フレームセットの横幅が不十分な時
	} else {
		// 右側にマージンを持たせる
		frame.cols = "*,1";
	}

	return;
}

//----------------------------------------------------------
// 右側のフレームを基準に調整する(右側フレーム:登録形式)
//----------------------------------------------------------
function adjustRightFrameWidth1() {
	var frame;
	var width_L;
	var width_R;

	// 検索結果部のフレームセットを取得
	frame = getResultFrameSet();
	if (frame == null) {
		return;
	}

	// 左右の調整後フレームサイズを取得
	width_L = getLeftFrameAjustWidth(45);
	width_R = getRightFrameAjustWidth1(30);

	// フレームセットの横幅が十分な時
	if (frame.offsetWidth > width_L + width_R) {
		// 左側のフレームに合せて調整する
		frame.cols = width_L + ",*";
	// フレームセットの横幅が不十分な時
	} else {
		// 右側のフレームに合せて調整する
		frame.cols = "*," + width_R;
	}

	return;
}

//----------------------------------------------------------
// 右側のフレームに合せて調整する(右側フレーム:一覧形式)
//----------------------------------------------------------
function adjustRightFrameWidth2() {
	var frame;
	var width_L;
	var width_R;

	// 検索結果部のフレームセットを取得
	frame = getResultFrameSet();
	if (frame == null) {
		return;
	}

	// 左右の調整後フレームサイズを取得
	width_L = getLeftFrameAjustWidth(40);
	width_R = getRightFrameAjustWidth2(60);

	// フレームセットの横幅が十分な時
	if (frame.offsetWidth > width_L + width_R) {
		// 左側のフレームに合せて調整する
		frame.cols = width_L + ",*";
	// フレームセットの横幅が不十分な時
	} else {
		// 右側のフレームの横幅が大きすぎないとき
		if (frame.offsetWidth > width_R + 60) {
			// 右側のフレームに合せて調整する
			frame.cols = "*," + width_R;
		// 右側のフレームの横幅が大きすぎるとき
		} else {
			// 右側のフレームに合せて調整する
			frame.cols = "60,*";
		}
	}

	return;
}

//----------------------------------------------------------
// 右側のフレームに合せて調整する(右側フレーム:エラー)
//----------------------------------------------------------
function adjustRightFrameWidth3() {
	var frame;

	// 検索結果部のフレームセットを取得
	frame = getResultFrameSet();
	if (frame == null) {
		return;
	}

	frame.cols = "*,620";

	return;
}

//----------------------------------------------------------
// 検索結果部のフレームセットを取得する
//----------------------------------------------------------
function getResultFrameSet() {
	return parent.document.getElementsByName("RES_FRAME")[0];
}

//----------------------------------------------------------
// 左側の調整後フレームサイズを取得
//----------------------------------------------------------
function getLeftFrameAjustWidth(margin) {
	var table;
	var width;

	table = parent.RESULT1.document.getElementById("viewTable")

	if (table == null) {
		width = 0;
	} else {
		width = table.offsetWidth + margin;
	}

	return width;
}

//----------------------------------------------------------
// 右側の調整後フレームサイズを取得(右側フレーム:登録形式)
//----------------------------------------------------------
function getRightFrameAjustWidth1(margin) {
	var form;
	var width

	form = parent.INPUT.document.forms[0];

	if (form == null) {
		width = 0;
	} else {
		width = form.offsetWidth + margin;
	}

	return width + margin;
}

//----------------------------------------------------------
// 右側の調整後フレームサイズを取得(右側フレーム:一覧形式)
//----------------------------------------------------------
function getRightFrameAjustWidth2(margin) {
	var table;
	var width;

	table = parent.INPUT.document.getElementById("viewTable")

	if (table == null) {
		width = 0;
	} else {
		width = table.offsetWidth + margin;
	}

	return width;
}
