<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7220"
	title	= "配置図登録"
	date	= "2015/09/14"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 配置図/座席表 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT SYSTEM_ID , LOC_GRP, LOC_KEY , LOC_COL, LOC_ROW, R_KEY1, R_KEY2, R_KEY3,
				NAME_JA, LABEL_NAME, BIKO, ICON, FGJ, UNIQ
		FROM GE18
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="LOC_GRP		like '{@LOC_GRP}'"		/>
		<og:and value="NAME_JA		like '{@NAME_JA}'"		/>
		<og:and value="LABEL_NAME	like '{@LABEL_NAME}'"	/>
		<og:and value="BIKO			like '{@BIKO}'"			/>
		<og:and value="R_KEY1		like '{@R_KEY1}'"		/>
		<og:and value="R_KEY2		like '{@R_KEY2}'"		/>
		<og:and value="R_KEY3		like '{@R_KEY3}'"		/>
	</og:where>
		ORDER BY SYSTEM_ID,LOC_GRP, NAME_JA,R_KEY1,R_KEY2,R_KEY3
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null"		/>
		<og:submit  action="MODIFY"  noWritable="LOC_GRP"	/>
		<og:submit  action="DELETE"  columnWritable="null"	/>
	<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "FGJ,UNIQ"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
