/****************************************************************************/
/* GF64 ( ﾀｽｸﾂﾘｰ )                                                          */
/*                                                                          */
/* Created : 2018/03/29 14:26:11                                            */
/****************************************************************************/

CREATE TABLE GF64 (
   PRJCODE      VARCHAR2 (   30 )                                       /*  10 PRJｺｰﾄﾞ      */
 , TASK_ID      NUMBER   (    5 )                                       /*  20 ﾀｽｸID        */
 , SEQ          NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  30 順           */
 , TASK_LEVEL   NUMBER   (    2 )                                       /*  40 ﾚﾍﾞﾙ         */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  50 名称         */
 , MEETING      VARCHAR2 (    1 )       DEFAULT '0'                     /*  60 ﾏｲﾙｽﾄｰﾝ      */
 , DYSTART      VARCHAR2 (   14 )                                       /*  70 開始日       */
 , DURATION     NUMBER   (  4,1 )                                       /*  80 期間         */
 , COMPLETE     NUMBER   (    3 )                                       /*  90 進捗率       */
 , PRIORITY     VARCHAR2 (    1 )                                       /* 100 優先度       */
 , NOTES        VARCHAR2 ( 4000 )                                       /* 110 ﾉｰﾄ          */
 , COLOR        VARCHAR2 (   50 )                                       /* 120 色記号       */
 , SHAPE        VARCHAR2 (   16 )                                       /* 130 模様         */
 , DEPEND_ID1   NUMBER   (    5 )                                       /* 140 先行ﾀｽｸID1   */
 , DEPEND_TYPE1 VARCHAR2 (    1 )                                       /* 150 先行ﾀｽｸﾀｲﾌﾟ1 */
 , DEPEND_ID2   NUMBER   (    5 )                                       /* 160 先行ﾀｽｸID2   */
 , DEPEND_TYPE2 VARCHAR2 (    1 )                                       /* 170 先行ﾀｽｸﾀｲﾌﾟ2 */
 , DEPEND_ID3   NUMBER   (    5 )                                       /* 180 先行ﾀｽｸID3   */
 , DEPEND_TYPE3 VARCHAR2 (    1 )                                       /* 190 先行ﾀｽｸﾀｲﾌﾟ3 */
 , DEPEND_ID4   NUMBER   (    5 )                                       /* 200 先行ﾀｽｸID4   */
 , DEPEND_TYPE4 VARCHAR2 (    1 )                                       /* 210 先行ﾀｽｸﾀｲﾌﾟ4 */
 , DEPEND_ID5   NUMBER   (    5 )                                       /* 220 先行ﾀｽｸID5   */
 , DEPEND_TYPE5 VARCHAR2 (    1 )                                       /* 230 先行ﾀｽｸﾀｲﾌﾟ5 */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GF64S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF64T00 
  BEFORE INSERT ON GF64
  FOR EACH ROW 
  BEGIN 
    SELECT GF64S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
