<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0005"
	title    = "ラベル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 物理削除以外の場合は、自身の行が、活動中かどうかをﾁｪｯｸします。 -->
<og:equals val1="DELETE" val2="{@sqlType}" notEquals="true" >
	<og:dataCheck
		dbid		= "{@MEM.TO_DBID}"
		command 	= "{@command}"
		from		= "GEA08"
		where		= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID] AND LANG=[LANG] AND CLM=[CLM] AND KBSAKU=[KBSAKU] AND FGJ in ('0','1')"
		errRemove	= "{@errRemove}"
	/>
</og:equals>

<!-- COPY の場合は、すでに、同一論理キーのデータが存在すれば、エラーにします。 -->
<og:equals val1="COPY" val2="{@sqlType}" >
	<og:dataCheck
		dbid		= "{@MEM.TO_DBID}"
		command 	= "{@command}"
		exist		= "false"
		from		= "GEA08"
		where		= "SYSTEM_ID=[SYSTEM_ID] AND LANG=[LANG] AND CLM=[CLM] AND KBSAKU=[KBSAKU] AND FGJ in ('0','1')"
	/>

	<!-- メモリ内での重複ﾁｪｯｸ -->
	<og:dataCheck
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		uniqCheckClms	= "SYSTEM_ID,LANG,CLM,KBSAKU"
	/>
</og:equals>

<og:value command="SETTBL" key="CLM" action="APPEND"/>
<og:tableUpdate
	dbid			= "{@MEM.TO_DBID}"
	command			= "{@command}"
	resourceType	= "GEA08"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA08"
		where			= "UNIQ = [UNIQ]"
		names			= "CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,KBLBL,SYSTEM_ID,LANG,RELEASE_NOTES,FGLOAD,CDKH,RDC_CODE"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<!--他システムIDのリソース更新ここから-->
<og:value command="SET" key="remocommand" value="LABEL"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<!--他システムリソース更新ここまで-->

<og:value command="REMOVE" key="CLM" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
