/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.get;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.get.IGetAccountReply;
import oracle.cloudstorage.api.get.IGetContainerReply;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.get.IGetRequestBuilder;
import oracle.cloudstorage.api.get.IGetRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;

public class GetRequestBuilder
extends AbstractRequestBuilder<IGetRequestBuilder, IGetRequestProcessor>
implements IGetRequestBuilder {
    private int chunkSize = -1;
    private boolean ignoreStriping = false;
    private boolean ignoreEncryption = false;

    public GetRequestBuilder(IRequestBuilder that) {
        super(that, Method.get);
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean ignoreStriping() {
        return this.ignoreStriping;
    }

    @Override
    public boolean ignoreEncryption() {
        return this.ignoreEncryption;
    }

    @Override
    public RetryStrategy root(ISession session, IGetRequestProcessor processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    private class Cryptography
    implements IGetRequestBuilder.Cryptography {
        private Cryptography() {
        }

        @Override
        public IGetObjectReply send() throws RetryException, InterruptedException {
            IGetObjectReply reply = ((IGetRequestProcessor)GetRequestBuilder.this.getProcessor()).object();
            return reply;
        }
    }

    private class Stripe
    extends Cryptography
    implements IGetRequestBuilder.Stripe {
        private Stripe() {
        }

        @Override
        public IGetRequestBuilder.Cryptography ignoreEncryption(boolean ignoreEncryption) {
            GetRequestBuilder.this.ignoreEncryption = ignoreEncryption;
            return new Cryptography();
        }

        @Override
        public IGetRequestBuilder.Cryptography ignoreEncryption() {
            return this.ignoreEncryption(true);
        }
    }

    private class Object
    extends Stripe
    implements IGetRequestBuilder.Object {
        private Object() {
        }

        @Override
        public Stripe ignoreStriping() {
            return this.ignoreStriping(true);
        }

        @Override
        public Stripe ignoreStriping(boolean ignoreStriping) {
            GetRequestBuilder.this.ignoreStriping = ignoreStriping;
            return new Stripe();
        }
    }

    private class Container
    implements IGetRequestBuilder.Container {
        private Container() {
        }

        @Override
        public IGetRequestBuilder.Object object(String objectId) {
            GetRequestBuilder.this.setObjectId(objectId);
            return new Object();
        }

        @Override
        public IGetContainerReply send() throws RetryException {
            IGetContainerReply reply = ((IGetRequestProcessor)GetRequestBuilder.this.getProcessor()).container();
            return reply;
        }
    }

    private class Account
    implements IGetRequestBuilder.Account {
        private Account() {
        }

        @Override
        public Container container(String containerId) {
            GetRequestBuilder.this.setContainerId(containerId);
            return new Container();
        }

        @Override
        public IGetAccountReply send() throws RetryException {
            IGetAccountReply reply = ((IGetRequestProcessor)GetRequestBuilder.this.getProcessor()).account();
            return reply;
        }
    }

    private class QueryParam
    extends Account
    implements IGetRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> queryParamProvider) {
            GetRequestBuilder.this.getQueryParams().put(queryParamProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            GetRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements IGetRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            GetRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class Buffer
    extends Header
    implements IGetRequestBuilder.Buffer {
        private Buffer() {
        }

        @Override
        public IGetRequestBuilder.Header buffer(int bufferByteArraySize) {
            return null;
        }
    }

    private class Chunk
    extends Buffer
    implements IGetRequestBuilder.Chunk {
        private Chunk() {
        }

        @Override
        public IGetRequestBuilder.Buffer chunk() {
            return this.chunk(true);
        }

        @Override
        public IGetRequestBuilder.Buffer chunk(boolean chunk) {
            int chunkSize = chunk ? 0 : -2;
            return this.chunk(chunkSize);
        }

        @Override
        public IGetRequestBuilder.Buffer chunk(int bytesPerChunk) {
            GetRequestBuilder.this.chunkSize = bytesPerChunk;
            return new Buffer();
        }
    }

    private class ReadTimeout
    extends Chunk
    implements IGetRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IGetRequestBuilder.Chunk read(long timeout, TimeUnit units) {
            GetRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Chunk();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IGetRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IGetRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            GetRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements IGetRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            GetRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

