/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.senlin.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.senlin.SenlinPolicyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.senlin.Policy;
import org.openstack4j.model.senlin.PolicyCreate;
import org.openstack4j.openstack.senlin.domain.SenlinPolicy;
import org.openstack4j.openstack.senlin.internal.BaseSenlinServices;

public class SenlinPolicyServiceImpl
extends BaseSenlinServices
implements SenlinPolicyService {
    @Override
    public List<? extends Policy> list() {
        return this.get(SenlinPolicy.Policy.class, this.uri("/policies", new Object[0])).execute().getList();
    }

    @Override
    public Policy create(PolicyCreate newPolicy) {
        Preconditions.checkNotNull((Object)newPolicy);
        return this.post(SenlinPolicy.class, this.uri("/policies", new Object[0])).entity(newPolicy).execute();
    }

    @Override
    public Policy get(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.get(SenlinPolicy.class, this.uri("/policies/%s", policyID)).execute();
    }

    @Override
    public Policy update(String policyID, PolicyCreate newPolicy) {
        Preconditions.checkNotNull((Object)policyID);
        Preconditions.checkNotNull((Object)newPolicy);
        return this.patch(SenlinPolicy.class, this.uri("/policies/%s", policyID)).entity(newPolicy).execute();
    }

    @Override
    public ActionResponse delete(String policyID) {
        Preconditions.checkNotNull((Object)policyID);
        return this.deleteWithResponse(this.uri("/policies/%s", policyID)).execute();
    }
}

