/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.gbp.L3policyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.gbp.L3Policy;
import org.openstack4j.openstack.gbp.domain.GbpL3Policy;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class L3policyServiceImpl
extends BaseNetworkingServices
implements L3policyService {
    @Override
    public List<? extends L3Policy> list() {
        return this.get(GbpL3Policy.L3Policies.class, this.uri("/grouppolicy/l3_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends L3Policy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpL3Policy.L3Policies> l3PoliciesInvocation = this.buildInvocation(filteringParams);
        return l3PoliciesInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpL3Policy.L3Policies> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpL3Policy.L3Policies> l3PoliciesInvocation = this.get(GbpL3Policy.L3Policies.class, "/grouppolicy/l3_policies");
        if (filteringParams == null) {
            return l3PoliciesInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                l3PoliciesInvocation = l3PoliciesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return l3PoliciesInvocation;
    }

    @Override
    public L3Policy get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpL3Policy.class, this.uri("/grouppolicy/l3_policies/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/l3_policies/%s", id)).execute();
    }

    @Override
    public L3Policy create(L3Policy l3Policy) {
        return this.post(GbpL3Policy.class, this.uri("/grouppolicy/l3_policies", new Object[0])).entity(l3Policy).execute();
    }

    @Override
    public L3Policy update(String l3PolicyId, L3Policy l3Policy) {
        Preconditions.checkNotNull((Object)l3PolicyId);
        Preconditions.checkNotNull((Object)l3Policy);
        return this.put(GbpL3Policy.class, this.uri("/grouppolicy/l3_policies/%s", l3PolicyId)).entity(l3Policy).execute();
    }
}

