rem /***********************************************************************/
rem /*  このファイルでは、openGionを起動するための環境変数を設定します。   */
rem /*  通常、このファイルを変更する必要はありません。                     */
rem /***********************************************************************/

rem /***********************************************************************/
rem /*  JavaとTomcatのパス設定です。                                       */
rem /***********************************************************************/
set APPS=%~dp0\..\..\apps
set UAP=%~dp0\..

set JAVA_HOME=%APPS%\%JDK_VER%
set CATALINA_HOME=%APPS%\%TOMCAT_VER%
set OFFICE_HOME=%APPS%\%OPENOFFICE_VER%

rem /***********************************************************************/
rem /*  Tomcatのserver.xmlに引き渡す各種変数設定                           */
rem /***********************************************************************/
set ENGINE_NAME=tomcat
set APP_BASE=%UAP%\webapps
set SYS_LOG_URL=log/%COMPUTERNAME%_%ENGINE_NAME%_$(yyyyMM).log
set WORK_DIR=%CATALINA_HOME%\work\%COMPUTERNAME%\%ENGINE_NAME%
set LOGS_DIR=%CATALINA_HOME%\logs\%COMPUTERNAME%\%ENGINE_NAME%

rem /***********************************************************************/
rem /*  OpenOffice帳票用設定                                               */
rem /*                                                                     */
rem /***********************************************************************/
rem set CLASSPATH=;%CLASSPATH%;%OFFICE_HOME%\Basis\program\classes\juh.jar;%OFFICE_HOME%\Basis\program\classes\unoil.jar;%
set CLASSPATH=;%CLASSPATH%;%OFFICE_HOME%\URE\java\juh.jar;%OFFICE_HOME%\Basis\program\classes\unoil.jar;
set PATH=;%PATH%;%OFFICE_HOME%\program;%OFFICE_HOME%\Basis\program;%OFFICE_HOME%\URE\bin;

rem /***********************************************************************/
rem /*  コンテキストパスの設定                                             */
rem /***********************************************************************/
set DEV_PATH=%APP_BASE%\%DEV_CTXT%
set CORE_PATH=%APP_BASE%\%CORE_CTXT%

rem /***********************************************************************/
rem /*  その他設定                                                         */
rem /***********************************************************************/
set CATALINA_OPTS=%CATALINA_OPTS% -server %JAVA_OPTS%			^
	-DshutdownPort=%SHUTDOWN_PORT%								^
	-DconnectorPort=%CONNECTOR_PORT%							^
	-DajpPort=%AJP_PORT%										^
	-DengineName=%ENGINE_NAME%									^
	-DconnectionDriver=%REALM_DRIVER%							^
	-DconnectionUrl=%REALM_URL%									^
	-DconnectionName=%REALM_NAME%								^
	-DconnectionPassword=%REALM_PASSWORD%						^
	-DappBase=%APP_BASE%										^
	-DworkDir=%WORK_DIR%										^
	-DlogsDir=%LOGS_DIR%										^
	-DSYS_LOG_URL=%SYS_LOG_URL% 

rem	-Xloggc:%LOGS_DIR%\gc.log									^
rem	-XX:+PrintGCDetails											^
rem	-XX:+PrintClassHistogram

set PATH=;%PATH%;%JAVA_HOME%\bin;
set TITLE=%TOMCAT_VER% ( %CONNECTOR_PORT% ) %REALM_NAME% %~dp0
