/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.object.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.Apis;
import org.openstack4j.api.storage.ObjectStorageContainerService;
import org.openstack4j.api.storage.ObjectStorageObjectService;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.object.SwiftContainer;
import org.openstack4j.model.storage.object.options.ContainerListOptions;
import org.openstack4j.model.storage.object.options.CreateUpdateContainerOptions;
import org.openstack4j.model.storage.object.options.ObjectPutOptions;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.storage.object.domain.SwiftContainerImpl;
import org.openstack4j.openstack.storage.object.functions.MapWithoutMetaPrefixFunction;
import org.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;
import org.openstack4j.openstack.storage.object.internal.BaseObjectStorageService;

public class ObjectStorageContainerServiceImpl
extends BaseObjectStorageService
implements ObjectStorageContainerService {
    @Override
    public List<? extends SwiftContainer> list() {
        return this.toList((Object[])this.get(SwiftContainerImpl[].class, new String[0]).param("format", "json").execute());
    }

    @Override
    public List<? extends SwiftContainer> list(ContainerListOptions options) {
        if (options == null) {
            return this.list();
        }
        return this.toList((Object[])this.get(SwiftContainerImpl[].class, new String[0]).param("format", "json").params(options.getOptions()).execute());
    }

    @Override
    public ActionResponse create(String name) {
        return this.create(name, null);
    }

    @Override
    public ActionResponse create(String name, CreateUpdateContainerOptions options) {
        Preconditions.checkNotNull((Object)name);
        return this.put(ActionResponse.class, "/", name).headers(options != null ? options.getOptions() : null).execute();
    }

    @Override
    public String createPath(String containerName, String path) {
        Preconditions.checkNotNull((Object)containerName);
        Preconditions.checkNotNull((Object)path);
        return Apis.get(ObjectStorageObjectService.class).put(containerName, path, null, ObjectPutOptions.create().contentType("application/directory"));
    }

    @Override
    public ActionResponse update(String name, CreateUpdateContainerOptions options) {
        Preconditions.checkNotNull((Object)name);
        return this.post(ActionResponse.class, "/", name).headers(options != null ? options.getOptions() : null).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResponse delete(String name) {
        Preconditions.checkNotNull((Object)name);
        HttpResponse resp = this.delete(Void.class, "/", name).executeWithResponse();
        try {
            if (resp.getStatus() == 409) {
                ActionResponse actionResponse = ActionResponse.actionFailed(String.format("Container %s is not empty", name), 409);
                return actionResponse;
            }
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
        return ToActionResponseFunction.INSTANCE.apply(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMetadata(String name) {
        Preconditions.checkNotNull((Object)name);
        HttpResponse resp = this.head(Void.class, "/", name).executeWithResponse();
        try {
            Map<String, String> map = MapWithoutMetaPrefixFunction.INSTANCE.apply(resp.headers());
            return map;
        }
        finally {
            HttpEntityHandler.closeQuietly(resp);
        }
    }

    @Override
    public boolean updateMetadata(String name, Map<String, String> metadata) {
        return this.invokeMetadata(name, "X-Container-Meta-", metadata);
    }

    @Override
    public boolean deleteMetadata(String name, Map<String, String> metadata) {
        return this.invokeMetadata(name, "X-Remove-Container-Meta-", metadata);
    }

    private boolean invokeMetadata(String name, String prefix, Map<String, String> metadata) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(metadata);
        return this.isResponseSuccess(this.post(Void.class, "/", name).headers(MetadataToHeadersFunction.create(prefix).apply(metadata)).executeWithResponse(), 204);
    }
}

