/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.internal;

import java.util.HashMap;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.types.Facing;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpExceptionHandler;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.internal.HttpExecutor;
import org.openstack4j.model.identity.AuthStore;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.v3.Authentication;
import org.openstack4j.model.identity.v3.Token;
import org.openstack4j.openstack.common.Auth;
import org.openstack4j.openstack.identity.v2.domain.Auth;
import org.openstack4j.openstack.identity.v2.domain.Credentials;
import org.openstack4j.openstack.identity.v2.domain.KeystoneAccess;
import org.openstack4j.openstack.identity.v2.domain.RaxApiKeyCredentials;
import org.openstack4j.openstack.identity.v2.domain.TokenAuth;
import org.openstack4j.openstack.identity.v3.domain.KeystoneAuth;
import org.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import org.openstack4j.openstack.internal.OSClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSAuthenticator {
    private static final String TOKEN_INDICATOR = "Tokens";
    private static final Logger LOG = LoggerFactory.getLogger(OSAuthenticator.class);

    public static OSClient invoke(AuthStore auth, String endpoint, Facing perspective, Config config, CloudProvider provider) {
        SessionInfo info = new SessionInfo(endpoint, perspective, false, provider);
        if (auth.getVersion().equals((Object)AuthVersion.V2)) {
            return OSAuthenticator.authenticateV2((Auth)((Object)auth), info, config);
        }
        return OSAuthenticator.authenticateV3((KeystoneAuth)auth, info, config);
    }

    public static OSClient invoke(KeystoneAuth auth, String endpoint, Facing perspective, Config config, CloudProvider provider) {
        SessionInfo info = new SessionInfo(endpoint, perspective, false, provider);
        return OSAuthenticator.authenticateV3(auth, info, config);
    }

    public static OSClient invoke(TokenAuth auth, String endpoint, Facing perspective, Config config, CloudProvider provider) {
        SessionInfo info = new SessionInfo(endpoint, perspective, false, provider);
        return OSAuthenticator.authenticateV2(auth, info, config);
    }

    public static void reAuthenticate() {
        LOG.debug("Re-Authenticating session due to expired Token or invalid response");
        OSClientSession session = OSClientSession.getCurrent();
        switch (session.getAuthVersion()) {
            case V2: {
                KeystoneAccess access = (KeystoneAccess)((OSClientSession.OSClientSessionV2)session).getAccess().unwrap();
                SessionInfo info = new SessionInfo(access.getEndpoint(), session.getPerspective(), true, session.getProvider());
                org.openstack4j.openstack.common.Auth auth = (org.openstack4j.openstack.common.Auth)(access.isCredentialType() ? access.getCredentials() : access.getTokenAuth());
                OSAuthenticator.authenticateV2((Auth)auth, info, session.getConfig());
                break;
            }
            default: {
                Token token = ((OSClientSession.OSClientSessionV3)session).getToken();
                SessionInfo info = new SessionInfo(token.getEndpoint(), session.getPerspective(), true, session.getProvider());
                OSAuthenticator.authenticateV3((KeystoneAuth)token.getCredentials(), info, session.getConfig());
            }
        }
    }

    private static OSClient.OSClientV2 authenticateV2(Auth auth, SessionInfo info, Config config) {
        HttpRequest<KeystoneAccess> request = HttpRequest.builder(KeystoneAccess.class).header("OS4J-Auth-Command", TOKEN_INDICATOR).endpoint(info.endpoint).method(HttpMethod.POST).path("/tokens").config(config).entity(auth).build();
        HttpResponse response = HttpExecutor.create().execute(request);
        if (response.getStatus() >= 400) {
            try {
                throw HttpExceptionHandler.mapException(response.getStatusMessage(), response.getStatus());
            }
            catch (Throwable throwable) {
                HttpEntityHandler.closeQuietly(response);
                throw throwable;
            }
        }
        KeystoneAccess access = response.getEntity(KeystoneAccess.class);
        access = auth.getType() == Auth.Type.CREDENTIALS ? access.applyContext(info.endpoint, (Credentials)auth) : (auth.getType() == Auth.Type.RAX_APIKEY ? access.applyContext(info.endpoint, (RaxApiKeyCredentials)auth) : access.applyContext(info.endpoint, (TokenAuth)auth));
        if (!info.reLinkToExistingSession) {
            return OSClientSession.OSClientSessionV2.createSession(access, info.perspective, info.provider, config);
        }
        OSClientSession.OSClientSessionV2 current = (OSClientSession.OSClientSessionV2)OSClientSession.getCurrent();
        current.access = access;
        return current;
    }

    private static OSClient.OSClientV3 authenticateV3(KeystoneAuth auth, SessionInfo info, Config config) {
        if (auth.getType().equals((Object)Auth.Type.TOKENLESS)) {
            Authentication.Scope.Domain domain;
            HashMap<String, String> headers = new HashMap<String, String>();
            Authentication.Scope.Project project = auth.getScope().getProject();
            if (project != null) {
                if (!OSAuthenticator.isEmpty(project.getId())) {
                    headers.put("X-Project-Id", project.getId());
                }
                if (!OSAuthenticator.isEmpty(project.getName())) {
                    headers.put("X-Project-Name", project.getName());
                }
                if ((domain = project.getDomain()) != null) {
                    if (!OSAuthenticator.isEmpty(domain.getId())) {
                        headers.put("X-Project-Domain-Id", domain.getId());
                    }
                    if (!OSAuthenticator.isEmpty(domain.getName())) {
                        headers.put("X-Project-Domain-Name", domain.getName());
                    }
                }
            } else {
                domain = auth.getScope().getDomain();
                if (domain != null) {
                    if (!OSAuthenticator.isEmpty(domain.getId())) {
                        headers.put("X-Domain-Id", domain.getId());
                    }
                    if (!OSAuthenticator.isEmpty(domain.getName())) {
                        headers.put("X-Domain-Name", domain.getName());
                    }
                }
            }
            KeystoneToken keystoneToken = new KeystoneToken();
            keystoneToken.setEndpoint(info.endpoint);
            return (OSClient.OSClientV3)OSClientSession.OSClientSessionV3.createSession(keystoneToken, null, null, config).headers(headers);
        }
        HttpRequest<KeystoneToken> request = HttpRequest.builder(KeystoneToken.class).header("OS4J-Auth-Command", TOKEN_INDICATOR).endpoint(info.endpoint).method(HttpMethod.POST).path("/auth/tokens").config(config).entity(auth).build();
        HttpResponse response = HttpExecutor.create().execute(request);
        if (response.getStatus() >= 400) {
            try {
                throw HttpExceptionHandler.mapException(response.getStatusMessage(), response.getStatus());
            }
            catch (Throwable throwable) {
                HttpEntityHandler.closeQuietly(response);
                throw throwable;
            }
        }
        KeystoneToken token = response.getEntity(KeystoneToken.class);
        token.setId(response.header("X-Subject-Token"));
        token = auth.getType().equals((Object)Auth.Type.CREDENTIALS) ? token.applyContext(info.endpoint, auth) : (token.getProject() != null ? token.applyContext(info.endpoint, new org.openstack4j.openstack.identity.v3.domain.TokenAuth(token.getId(), auth.getScope().getProject().getName(), auth.getScope().getProject().getId())) : (token.getDomain() != null ? token.applyContext(info.endpoint, new org.openstack4j.openstack.identity.v3.domain.TokenAuth(token.getId(), auth.getScope().getDomain().getName(), auth.getScope().getDomain().getId())) : token.applyContext(info.endpoint, new org.openstack4j.openstack.identity.v3.domain.TokenAuth(token.getId(), null, null))));
        String reqId = response.header("x-openstack-request-id");
        if (!info.reLinkToExistingSession) {
            OSClientSession.OSClientSessionV3 v3 = OSClientSession.OSClientSessionV3.createSession(token, info.perspective, info.provider, config);
            v3.reqId = reqId;
            return v3;
        }
        OSClientSession.OSClientSessionV3 current = (OSClientSession.OSClientSessionV3)OSClientSession.OSClientSessionV3.getCurrent();
        current.token = token;
        current.reqId = reqId;
        return current;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    private static class SessionInfo {
        String endpoint;
        Facing perspective;
        boolean reLinkToExistingSession;
        CloudProvider provider;

        SessionInfo(String endpoint, Facing perspective, boolean reLinkToExistingSession, CloudProvider provider) {
            this.endpoint = endpoint;
            this.perspective = perspective;
            this.reLinkToExistingSession = reLinkToExistingSession;
            this.provider = provider;
        }
    }
}

