/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.Closeable;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.StorageAPI;

public class StorageAPI_aws
implements StorageAPI {
    private String s3AccessKey = HybsSystem.sys((String)"CLOUD_STORAGE_S3_ACCESS_KEY");
    private String s3SecretKey = "";
    private String s3ServiceEndPoint = "";
    private String s3Region = "";
    String s3bucket = "";
    AmazonS3 client = null;

    public StorageAPI_aws(String string, HttpSession httpSession) {
        this.s3bucket = string;
        if (StringUtils.isEmpty((CharSequence)this.s3AccessKey)) {
            this.client = (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(false))).build();
        } else {
            this.s3SecretKey = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SECRET_KEY");
            this.s3ServiceEndPoint = HybsSystem.sys((String)"CLOUD_STORAGE_S3_SERVICE_END_POINT");
            this.s3Region = HybsSystem.sys((String)"CLOUD_STORAGE_S3_REGION");
            this.initCheck();
            BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(this.s3AccessKey, this.s3SecretKey);
            AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(this.s3ServiceEndPoint, this.s3Region);
            this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials))).withEndpointConfiguration(endpointConfiguration)).build();
        }
        if (!this.client.doesBucketExist(string)) {
            this.client.createBucket(string);
        }
    }

    private void initCheck() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)this.s3AccessKey)) {
            stringBuilder.append("CLOUD_STORAGE_S3_ACCESS_KEY");
        }
        if (StringUtils.isEmpty((CharSequence)this.s3SecretKey)) {
            stringBuilder.append(",CLOUD_STORAGE_S3_SECRET_KEY");
        }
        if (StringUtils.isEmpty((CharSequence)this.s3ServiceEndPoint)) {
            stringBuilder.append(",CLOUD_STORAGE_S3_SERVICE_END_POINT");
        }
        if (StringUtils.isEmpty((CharSequence)this.s3Region)) {
            stringBuilder.append(",CLOUD_STORAGE_S3_REGION");
        }
        if (stringBuilder.length() > 0) {
            throw new HybsSystemException("AWS\u306e\uff77\uff70\u60c5\u5831(" + stringBuilder.toString() + ")\u304c\uff7c\uff7d\uff83\uff91\uff98\uff7f\uff70\uff7d\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public void add(InputStream inputStream, String string, String string2, HttpSession httpSession) {
        Closeable closeable = null;
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.s3bucket, string + string2, inputStream, objectMetadata);
            this.client.putObject(putObjectRequest);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u3078\u306e\u30d5\u30a1\u30a4\u30eb\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002updFolder:");
            stringBuilder.append(string);
            stringBuilder.append(" updFileName:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        finally {
            Closer.ioClose(closeable);
            Closer.ioClose((Closeable)inputStream);
        }
    }

    public InputStream get(String string, HttpSession httpSession) {
        S3ObjectInputStream s3ObjectInputStream = null;
        try {
            S3Object s3Object = this.client.getObject(this.s3bucket, string);
            s3ObjectInputStream = s3Object.getObjectContent();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return s3ObjectInputStream;
    }

    public void copy(String string, String string2, HttpSession httpSession) {
        try {
            CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.s3bucket, string, this.s3bucket, string2);
            this.client.copyObject(copyObjectRequest);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002oldFilePath:");
            stringBuilder.append(string);
            stringBuilder.append(" newFilePath:");
            stringBuilder.append(string2);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void delete(String string, HttpSession httpSession) {
        try {
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(this.s3bucket, string);
            this.client.deleteObject(deleteObjectRequest);
            this.client.deleteObject(this.s3bucket, string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, HttpSession httpSession) {
        String string4 = string + string3;
        String string5 = string + string2;
        if (this.exists(string4, httpSession) && bl) {
            String string6 = string + "_backup/" + string3 + "_" + System.currentTimeMillis() + '.' + FileUtil.getExtension((String)string3);
            this.copy(string4, string6, httpSession);
        }
        this.copy(string5, string4, httpSession);
        this.delete(string5, httpSession);
    }

    public boolean exists(String string, HttpSession httpSession) {
        boolean bl = true;
        try {
            if (!this.client.doesObjectExist(this.s3bucket, string)) {
                bl = false;
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30d5\u30a1\u30a4\u30eb\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filePath:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        return bl;
    }

    public String[] list(String string, HttpSession httpSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ListObjectsV2Request listObjectsV2Request = new ListObjectsV2Request().withBucketName(this.s3bucket).withPrefix(string);
            ListObjectsV2Result listObjectsV2Result = this.client.listObjectsV2(listObjectsV2Request);
            List list = listObjectsV2Result.getObjectSummaries();
            for (S3ObjectSummary s3ObjectSummary : list) {
                arrayList.add(s3ObjectSummary.getKey());
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u4e00\u89a7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002startsWith:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append("e");
            throw new HybsSystemException(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Map<String, String> getInfo(String string, HttpSession httpSession) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ObjectMetadata objectMetadata = null;
        try {
            objectMetadata = this.client.getObjectMetadata(this.s3bucket, string);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u30d5\u30a1\u30a4\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002path:");
            stringBuilder.append(string);
            stringBuilder.append(" errInfo:");
            stringBuilder.append(exception);
            throw new HybsSystemException(stringBuilder.toString());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        hashMap.put("SIZE", String.valueOf(objectMetadata.getContentLength()));
        hashMap.put("LASTMODIFIED", simpleDateFormat.format(objectMetadata.getLastModified()));
        return hashMap;
    }
}

