package gf;

import java.util.ArrayList;
import java.util.List;

import org.opengion.fukurou.business.BizLogic_TABLE;
import org.opengion.penguin.math.statistics.HybsSimpleRegression;
import org.opengion.penguin.math.statistics.HybsSingleRegression;
import org.opengion.penguin.math.statistics.HybsSquadraticRegression;

/**
 * 指定したDB項目の単回帰係数を出力します。
 * penguinパッケージを利用して、相関係数を計算します。
 * 
 * @version 5.0
 * @author T.OTA
 * @author JDK1.7
 *
 */
public class GFX029A extends BizLogic_TABLE{
	List<double[]> dataList	= new ArrayList<double[]>();
	
	/**
	 * メインカーソルの各行で呼ばれるロジックを定義します
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean befall( int row ) {
		double[] lineData = new double[2];
		
		String clm1 = var("COLUMN_NAME1");
		String clm2 = var("COLUMN_NAME2");
		if(isEmpty( line(clm1) )){ 
			lineData[0] = 0;
		}else{
			lineData[0] = lined(clm1);
		}
		if(isEmpty( line(clm2))){
			lineData[1] = 0;
		}else{
			lineData[1] = lined(clm2);
		}
		dataList.add( lineData );
		return true;
	}

	/**
	 * 空ﾁｪｯｸ
	 * @param str
	 * @return true:空 false:空でない
	 */
	private boolean isEmpty(String str){
		if("".equals( str ) || str == null){
			return true;
		}
		return false;
	}
	
	/**
	 * 最後の行の終わりで呼び出し
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean last() {
		StringBuilder sb = new StringBuilder();
		
		HybsSingleRegression hsr;
		
		String methodCalc	= var("METHOD_CALC");
		
		if("1".equals(methodCalc)){
			// 線形単回帰
			hsr = new HybsSimpleRegression((double[][])dataList.toArray(new double[dataList.size()][2]));
		}else{
			// ２次回帰
			hsr = new HybsSquadraticRegression((double[][])dataList.toArray(new double[dataList.size()][2]));
		}
		
		double[] coefficients = hsr.getCoefficient();
		
		if("1".equals(methodCalc)){
			sb.append( "<table border='1'><tr><td class='row_h'><div>" );
			sb.append( "傾き：</td><td id='slope'>" ).append( coefficients[0] ).append( "</td></tr><tr><td class='row_h'>" );
			sb.append( "切片：</td><td id='intercept'>" ).append( coefficients[1] ).append( "</td></tr><tr><td class='row_h'>" );
			sb.append( "決定係数：</td><td>" ).append( coefficients[2] );
			sb.append("</tr></td></table>");
		}else{
			sb.append( "<table border='1'><tr><td class='row_h'><div>" );
			sb.append( "２次の係数：</td><td id='c1'>" ).append( coefficients[0] ).append( "</td></tr><tr><td class='row_h'>" );
			sb.append( "１次の係数：</td><td id='c2'>" ).append( coefficients[1] ).append( "</td></tr><tr><td class='row_h'>" );
			sb.append( "０次の係数：</td><td id='c3'>" ).append( coefficients[2] );
			sb.append("</tr></td></table>");
		}
		
		rtn(sb.toString());
		
		return true;
	}
}
