/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.util.Closer;

public class GZIPResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream baos = null;
    protected GZIPOutputStream gzipstream = null;
    protected boolean isClosed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;

    public GZIPResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this.response = httpServletResponse;
        this.output = httpServletResponse.getOutputStream();
        this.baos = new ByteArrayOutputStream();
        this.gzipstream = new GZIPOutputStream(this.baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.gzipstream.finish();
            byte[] byArray = this.baos.toByteArray();
            this.response.setContentLength(byArray.length);
            this.response.addHeader("Content-Encoding", "gzip");
            this.output.write(byArray);
            this.output.flush();
        }
        finally {
            this.isClosed = true;
            Closer.ioClose((Closeable)this.output);
        }
    }

    public void flush() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.gzipstream.flush();
    }

    public void write(int n) throws IOException {
        if (this.isClosed) {
            return;
        }
        this.gzipstream.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            return;
        }
        this.gzipstream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.isClosed;
    }

    public boolean isReady() {
        return false;
    }
}

