/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.opengion.fukurou.fileexec.AppliExec;
import org.opengion.fukurou.fileexec.BasePath;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.FileWatch;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class FileExec {
    private static final XLogger LOGGER = XLogger.getLogger(FileExec.class.getName());
    public static final String CR = System.getProperty("line.separator");
    private final TBL_GE71 tableGE71;
    private final String systemId;
    private final String rsrvNo;
    private final String execId;
    private final String fileFltr;
    private final BasePath basePath;
    private final FileWatch fWatch;

    public FileExec(CommandLine commandLine) {
        LOGGER.debug(() -> "\u2461 CommandLine=" + commandLine);
        this.systemId = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        this.rsrvNo = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        this.execId = commandLine.getValue(CommandLine.GE70.EXECID);
        this.fileFltr = commandLine.getValue(CommandLine.GE70.FILE_FILTER);
        this.basePath = new BasePath(commandLine.getValue(CommandLine.GE70.DIR_BASE), commandLine.getValue(CommandLine.GE70.DIR_SUB), commandLine.getValue(CommandLine.GE70.DIR_WORK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_OK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_NG));
        this.tableGE71 = new TBL_GE71(this.systemId, this.rsrvNo, this.execId);
        this.fWatch = new FileWatch(this.basePath.SUB_PATH);
    }

    public void watchStart() {
        LOGGER.debug(() -> "\u2463 [watchStart()]");
        this.fWatch.setEventKinds(FileWatch.CREATE, FileWatch.MODIFY);
        this.fWatch.setPathMatcher(new PathMatcherSet().addFileName(this.fileFltr));
        this.fWatch.callback((string, path) -> this.checkFile((String)string, (Path)path));
        this.fWatch.start();
    }

    public void watchStop() {
        LOGGER.debug(() -> "\u2462 [watchStop()]");
        this.fWatch.stop();
    }

    private void checkFile(String string, Path path) {
        Path path2 = null;
        Path path3 = null;
        Path path4 = null;
        String string2 = "";
        try {
            if (FileUtil.stablePath(path)) {
                String string3;
                LOGGER.debug(() -> "\u2464 event=" + string + " , Path=" + path);
                path2 = FileUtil.backup(path, this.basePath.WORK_PATH);
                String string4 = StringUtil.getTimeFormat();
                AppliExec appliExec = AppliExec.newInstance(this.systemId, this.execId);
                int n = appliExec.exec(path2);
                if (n >= 0) {
                    path3 = FileUtil.backup(path2, this.basePath.OK_PATH);
                    string3 = "2";
                } else {
                    path4 = FileUtil.backup(path2, this.basePath.NG_PATH);
                    string3 = "8";
                }
                this.tableGE71.dbInsert(string3, string4, path, path3, path4, n, string2);
                LOGGER.info(() -> "DAT execute. " + path + " , FGTKAN=" + string3 + " , kensu=" + n);
            } else {
                LOGGER.info(() -> "checkFile Not stablePath. " + path);
            }
        }
        catch (Throwable throwable) {
            string2 = MsgUtil.errPrintln(throwable, "MSG0021", path);
            if (path2 != null && Files.exists(path2, new LinkOption[0])) {
                path4 = FileUtil.backup(path2, this.basePath.NG_PATH);
            }
            this.tableGE71.dbInsert("7", StringUtil.getTimeFormat(), path, null, path4, -1, string2);
        }
    }

    public String toString() {
        return String.join((CharSequence)" , ", this.systemId, this.rsrvNo, this.execId);
    }

    private static final class TBL_GE71 {
        private static final String[] KEYS = new String[]{"SYSTEM_ID", "RSRV_NO", "EXECID", "FGTKAN", "TMSTR", "TMEND", "FILE_IN", "FILE_OK", "FILE_NG", "SUTORI ", "ERRMSG ", "DYSET", "DYUPD"};
        private static final String[] CON_KEYS = new String[]{"FGJ", "PGSET", "PGUPD"};
        private static final String[] CON_VALS = new String[]{"1", "FileExec", "FileExec"};
        private static final String INS_QUERY = DBUtil.getInsertSQL("GE71", KEYS, CON_KEYS, CON_VALS);
        private final String systemId;
        private final String rsrvNo;
        private final String execId;

        public TBL_GE71(String string, String string2, String string3) {
            this.systemId = string;
            this.rsrvNo = string2;
            this.execId = string3;
        }

        public void dbInsert(String string, String string2, Path path, Path path2, Path path3, int n, String string3) {
            String string4 = StringUtil.getTimeFormat();
            String string5 = path == null ? "" : path.toString();
            String string6 = path2 == null ? "" : path2.toString();
            String string7 = path3 == null ? "" : path3.toString();
            String[] stringArray = new String[]{this.systemId, this.rsrvNo, this.execId, string, string2, string4, string5, string6, string7, String.valueOf(n), string3, string4, string4};
            LOGGER.debug(() -> "\u2465 GE71.dbInsert query=" + INS_QUERY + "\n\t values=" + Arrays.toString(stringArray));
            DBUtil.execute(INS_QUERY, stringArray);
        }
    }
}

