/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.TableFormatter;
import org.opengion.hayabusa.html.ViewForm;
import org.opengion.hayabusa.html.ViewMarker;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractViewForm
implements ViewForm {
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    protected static final int BUFFER_LARGE = 500;
    private static final String LAYER_ST0 = "";
    private static final String LAYER_END0 = "";
    private static final String LAYER_END2 = "<a href=\"#top\" name=\"h_end\" id=\"h_end\" ></a></div></div></div></div>";
    private String name = "";
    private DBTableModel table;
    private DBColumn[] dbColumn;
    private boolean[] clmWritable;
    private boolean[] writeCtrl;
    private boolean[] clmDisplay;
    private boolean[] clmGroup;
    private String groupClass = "";
    private boolean useGroupDir;
    private CLM_GRP groupType;
    private boolean[] sortKeys;
    private boolean[] useEventCols;
    private boolean useSorterKeys;
    private String sorterQuery = "";
    private String viewFormID;
    private int startNo;
    private int pageSize = HybsSystem.sysInt("HTML_PAGESIZE");
    private boolean rowWritableFlag;
    private ViewMarker viewLink;
    private ViewMarker viewMarker;
    private ViewMarker editMarker;
    private String selectedType = "checkbox";
    private String numberType = "sequence";
    private int numberTypeClm = -1;
    private String[] numberTypeData;
    private String optTypeAttri;
    private boolean noMessage;
    private int backLinkCount;
    private int headerSkipCount;
    private boolean skip = false;
    private int useCheckControl;
    private boolean useTableSorter = HybsSystem.sysBool("VIEW_USE_TABLE_SORTER");
    private boolean numberDisplay = true;
    private int scrollRowNo = -1;
    private static final String NO_HEADER = "No";
    private ConcurrentMap<String, String> viewParam;
    private List<String[]> viewArrayList;
    private int columnCount;
    private int rowCount;
    private int bgColorCycle = 1;
    private static final String BG_COLOR_ROW0 = " class=\"row_0\"";
    private static final String BG_COLOR_ROW1 = " class=\"row_1\"";
    private static final String BG_COLOR_ROWSEL = " class=\"row_sel\"";
    private static final String BG_WARNING_COLOR_ROW0 = " class=\"row_0 row_warning\"";
    private static final String BG_WARNING_COLOR_ROW1 = " class=\"row_1 row_warning\"";
    private static final String BG_ERROR_COLOR_ROW0 = " class=\"row_0 row_error\"";
    private static final String BG_ERROR_COLOR_ROW1 = " class=\"row_1 row_error\"";
    private String colorRow0 = " class=\"row_0\"";
    private String colorRow1 = " class=\"row_1\"";
    private int bgColorClsClmNo = -1;
    private boolean useScrollBar = HybsSystem.sysBool("VIEW_USE_SCROLLBAR");
    private boolean firstChecked;
    private boolean useSelRowColor;
    private String clazz = "viewTable";
    private ResourceManager resourceManager;
    private String height;
    private String width;
    private boolean skipNoEdit;
    private static final String HIDDEN_ROW_KEY = "rid";
    private static final String HIDDEN_CDKH_KEY = "kh";
    private boolean noTransition;
    private String gamenId;
    private boolean[] clmBulkSet;
    private String[] nullCheck;
    private String[] mustAnyCheck;
    private String viewClass = "VIEW_h_tblmdl";

    protected AbstractViewForm() {
    }

    @Override
    public void init(DBTableModel dBTableModel) {
        this.table = dBTableModel;
        if (dBTableModel != null) {
            this.rowCount = dBTableModel.getRowCount();
            this.columnCount = dBTableModel.getColumnCount();
            this.clmWritable = new boolean[this.columnCount];
            this.writeCtrl = new boolean[this.columnCount];
            this.clmDisplay = new boolean[this.columnCount];
            this.clmGroup = new boolean[this.columnCount];
            this.sortKeys = new boolean[this.columnCount];
            this.dbColumn = new DBColumn[this.columnCount];
            this.useEventCols = new boolean[this.columnCount];
            this.clmBulkSet = new boolean[this.columnCount];
            Arrays.fill(this.clmWritable, false);
            Arrays.fill(this.writeCtrl, false);
            Arrays.fill(this.clmDisplay, true);
            Arrays.fill(this.clmGroup, false);
            Arrays.fill(this.sortKeys, false);
            Arrays.fill(this.useEventCols, false);
            Arrays.fill(this.clmBulkSet, false);
            for (int i = 0; i < this.columnCount; ++i) {
                this.dbColumn[i] = dBTableModel.getDBColumn(i);
            }
            this.rowWritableFlag = "WRITABLE".equalsIgnoreCase(this.getColumnName(0));
            this.scrollRowNo = -1;
            this.firstChecked = false;
            this.nullCheck = dBTableModel.getMustArray();
            this.mustAnyCheck = dBTableModel.getMustAnyArray();
        }
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setId(String string) {
        this.viewFormID = string;
    }

    @Override
    public String getId() {
        return this.viewFormID;
    }

    @Override
    public String create() {
        return this.create(0, this.rowCount);
    }

    @Override
    public void create(int n, int n2, Writer writer) throws IOException {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001\u76f4\u63a5\u767b\u9332\u7528\u306e Writer \u306e\u30d3\u30e5\u30fc\u3067\u306e\u307f\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002");
    }

    @Override
    public void clear() {
        this.name = "";
        this.table = null;
        this.dbColumn = null;
        this.clmWritable = null;
        this.writeCtrl = null;
        this.clmDisplay = null;
        this.clmGroup = null;
        this.groupClass = "";
        this.useGroupDir = false;
        this.groupType = null;
        this.sortKeys = null;
        this.useSorterKeys = false;
        this.sorterQuery = "";
        this.startNo = 0;
        this.pageSize = HybsSystem.sysInt("HTML_PAGESIZE");
        this.rowWritableFlag = false;
        this.viewLink = null;
        this.viewMarker = null;
        this.editMarker = null;
        this.backLinkCount = 0;
        this.selectedType = "checkbox";
        this.numberType = "sequence";
        this.numberTypeClm = -1;
        this.numberTypeData = null;
        this.headerSkipCount = 0;
        this.skip = false;
        this.useCheckControl = 0;
        this.viewParam = null;
        this.viewArrayList = null;
        this.numberDisplay = true;
        this.columnCount = 0;
        this.bgColorCycle = 1;
        this.bgColorClsClmNo = -1;
        this.colorRow0 = BG_COLOR_ROW0;
        this.colorRow1 = BG_COLOR_ROW1;
        this.useScrollBar = HybsSystem.sysBool("VIEW_USE_SCROLLBAR");
        this.firstChecked = false;
        this.useSelRowColor = false;
        this.height = null;
        this.width = null;
        this.skipNoEdit = false;
        this.useEventCols = null;
        this.clmBulkSet = null;
        this.nullCheck = null;
        this.mustAnyCheck = null;
    }

    protected String getCountForm(int n, int n2) {
        if (this.noMessage) {
            return "";
        }
        int n3 = n + n2 > this.rowCount ? this.rowCount : n + n2;
        StringBuilder stringBuilder = new StringBuilder(200).append("<div class=\"orgRowCntMsg\">").append('[').append(n + 1).append(" - ").append(n3).append("]/[").append(this.rowCount).append("]</div>");
        return stringBuilder.toString();
    }

    protected String getColumnLabel(int n) {
        return this.dbColumn[n].getLabel();
    }

    protected String getColumnName(int n) {
        return this.dbColumn[n].getName();
    }

    protected String getValue(int n, int n2) {
        return (String)this.table.getValue(n, n2);
    }

    protected String getRendererValue(int n, int n2) {
        return this.getRendererValue(n, n2, this.getValue(n, n2));
    }

    protected String getRendererValue(int n, int n2, String string) {
        String string2 = this.dbColumn[n2].getRendererValue(n, string);
        if (this.useEventCols[n2] && this.isWritable(n)) {
            string2 = this.dbColumn[n2].getEventColumnTag(string2, this.getValue(n, n2), n, false);
        }
        if (this.viewLink != null) {
            string2 = this.viewLink.getMarkerString(n, n2, string2);
        }
        if (this.viewMarker != null) {
            string2 = this.viewMarker.getMarkerString(n, n2, string2);
        }
        if (this.groupType != null && this.clmGroup[n2] && string != null && string2 != null && string2.length() > 0 && (this.useGroupDir && n2 > 0 && string.equals(this.getValue(n, n2 - 1)) || !this.useGroupDir && n > 0 && n != this.startNo && string.equals(this.getValue(n - 1, n2)))) {
            string2 = this.groupType == CLM_GRP.KIGO ? this.groupClass : "<span class=\"" + this.groupClass + "\">" + string2 + "</span>";
        }
        return string2;
    }

    protected String getEditorValue(int n, int n2, String string) {
        String string2 = this.dbColumn[n2].getEditorValue(n, string);
        if (this.useEventCols[n2]) {
            string2 = this.dbColumn[n2].getEventColumnTag(string2, this.getValue(n, n2), n, true);
        }
        if (this.editMarker != null) {
            string2 = this.editMarker.getMarkerString(n, n2, string2);
        }
        return string2;
    }

    protected String getValueLabel(int n, int n2) {
        boolean bl;
        String string = this.getValue(n, n2);
        boolean bl2 = bl = this.isColumnWritable(n2) && this.isWritable(n);
        if (this.writeCtrl[n2] && string != null && string.length() > 0 && string.charAt(0) == '_') {
            bl = false;
            string = string.substring(1);
        }
        return bl ? this.getEditorValue(n, n2, string) : this.getRendererValue(n, n2, string);
    }

    protected String getColumnDbType(int n) {
        return this.dbColumn[n].getDbType();
    }

    protected String getClassName(int n) {
        return this.dbColumn[n].getClassName();
    }

    protected boolean isColumnWritable(int n) {
        return this.clmWritable[n];
    }

    @Override
    public void setColumnWritable(int n, boolean bl) {
        this.clmWritable[n] = bl;
    }

    @Override
    public void setColumnWritable(String string) {
        if (string != null) {
            this.setBooleanArray(string, true, this.clmWritable);
            this.setUseEventCols();
        }
    }

    @Override
    public void setNoWritable(String string) {
        if (string != null) {
            this.setBooleanArray(string, false, this.clmWritable);
            this.setUseEventCols();
        }
    }

    private void setUseEventCols() {
        block0: for (int i = 0; i < this.dbColumn.length; ++i) {
            String string = this.dbColumn[i].getEventColumn();
            if (string == null || string.length() <= 0) continue;
            String[] stringArray = StringUtil.csv2Array((String)string);
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (string2.charAt(0) == '_') {
                    string2 = string2.substring(1);
                }
                if (!this.isColumnWritable(this.table.getColumnNo(string2))) continue;
                this.useEventCols[i] = true;
                continue block0;
            }
        }
    }

    protected boolean isWritable(int n) {
        boolean bl = this.table.isRowWritable(n);
        if (bl && this.rowWritableFlag) {
            String string = (String)this.table.getValue(n, 0);
            boolean bl2 = bl = "TRUE".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string) || "2".equalsIgnoreCase(string);
            if (!(bl || "FALSE".equalsIgnoreCase(string) || "0".equalsIgnoreCase(string) || "".equalsIgnoreCase(string))) {
                String string2 = "writable \u306f\u3001TRUE,FALSE,0,1,2,null \u4ee5\u5916\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002  row=[" + (n + 1) + "]  val=[" + string + "]";
                throw new HybsSystemException(string2);
            }
        }
        return bl;
    }

    protected boolean isChecked(int n) {
        boolean bl = this.table.isRowChecked(n);
        if (this.rowWritableFlag) {
            String string = (String)this.table.getValue(n, 0);
            bl = bl || "2".equalsIgnoreCase(string);
        }
        return bl;
    }

    protected boolean isFirstChecked(int n) {
        boolean bl;
        if (this.firstChecked) {
            return false;
        }
        if (n >= this.rowCount) {
            return false;
        }
        if (this.scrollRowNo >= 0) {
            bl = n == this.scrollRowNo;
        } else {
            if (n == 0 && this.table.isRowChecked(n)) {
                this.firstChecked = true;
                return false;
            }
            bl = this.table.isRowChecked(n);
        }
        if (bl) {
            this.firstChecked = true;
        }
        return bl;
    }

    @Override
    public boolean isMarked(int n) {
        return this.isWritable(n) && this.isChecked(n);
    }

    protected boolean isColumnDisplay(int n) {
        return (!this.rowWritableFlag || n != 0) && this.clmDisplay[n];
    }

    protected int getColumnDisplayCount() {
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.isColumnDisplay(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void setColumnDisplay(int n, boolean bl) {
        this.clmDisplay[n] = bl;
    }

    @Override
    public void setColumnDisplay(String string) {
        this.setBooleanArray(string, true, this.clmDisplay);
    }

    @Override
    public void setNoDisplay(String string) {
        this.setBooleanArray(string, false, this.clmDisplay);
    }

    @Override
    public void setColumnGroup(String string) {
        if (string != null) {
            if (this.groupType == null) {
                this.groupType = CLM_GRP.KIGO;
            }
            this.setBooleanArray(string, true, this.clmGroup);
        }
    }

    @Override
    public void setNoGroup(String string) {
        if (string != null) {
            if (this.groupType == null) {
                this.groupType = CLM_GRP.KIGO;
            }
            this.setBooleanArray(string, false, this.clmGroup);
        }
    }

    @Override
    public void setGroupClass(String string) {
        if (string != null) {
            char c;
            this.groupClass = string;
            this.groupType = this.groupClass.isEmpty() ? CLM_GRP.KIGO : ((c = this.groupClass.charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' ? CLM_GRP.CHAR : CLM_GRP.KIGO);
        }
    }

    @Override
    public void setGroupDir(boolean bl) {
        this.useGroupDir = bl;
    }

    @Override
    public void setTableSorterKeys(String string) {
        if (string != null) {
            this.setBooleanArray(string, true, this.sortKeys);
            this.useSorterKeys = true;
        }
    }

    protected int getColumnSize(int n) {
        return this.dbColumn[n].getTotalSize();
    }

    protected int getColumnCount() {
        return this.columnCount;
    }

    protected int getRowCount() {
        return this.rowCount;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected String getName() {
        return this.name;
    }

    protected int getColumnNo(String string) {
        return this.table.getColumnNo(string);
    }

    @Override
    public int getStartNo() {
        return this.startNo;
    }

    @Override
    public void setStartNo(int n) {
        if (n >= 0) {
            this.startNo = n;
        }
    }

    @Override
    public int getBackLinkCount() {
        return this.backLinkCount;
    }

    @Override
    public void setBackLinkCount(int n) {
        if (n >= 0) {
            this.backLinkCount = n;
        }
    }

    @Override
    public int getHeaderSkipCount() {
        return this.headerSkipCount;
    }

    @Override
    public void setHeaderSkipCount(int n) {
        this.headerSkipCount = n;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int n) {
        if (n > 0) {
            this.pageSize = n;
        }
    }

    @Override
    public void setFormatterList(List<TableFormatter> list) {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u95a2\u4fc2\u306e\u30d3\u30e5\u30fc\u3067\u306e\u307f\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002");
    }

    protected String getTypeCaseValue(char c, int n, int n2) {
        String string;
        if (n < 0) {
            switch (c) {
                case '#': {
                    string = this.getColumnLabel(n2);
                    break;
                }
                case '$': {
                    string = this.getRendererValue(0, n2);
                    break;
                }
                case '!': {
                    string = this.getValue(0, n2);
                    break;
                }
                default: {
                    string = this.getSortedColumnLabel(n2);
                    break;
                }
            }
        } else {
            switch (c) {
                case '#': {
                    string = this.getColumnLabel(n2);
                    break;
                }
                case '$': {
                    string = this.getRendererValue(n, n2);
                    break;
                }
                case '!': {
                    string = this.getValue(n, n2);
                    break;
                }
                default: {
                    string = this.getValueLabel(n, n2);
                }
            }
        }
        return string;
    }

    @Override
    public void setSelectedType(String string) {
        if (string != null) {
            this.selectedType = "checkbox".equalsIgnoreCase(string) || "radio".equalsIgnoreCase(string) || "hidden".equalsIgnoreCase(string) ? string : null;
        }
    }

    @Override
    public void setNumberType(String string) {
        this.numberType = string;
        this.numberDisplay = true;
        if (string != null && !string.startsWith("seq") && !string.startsWith("none")) {
            if (string.startsWith("skip=")) {
                this.numberTypeClm = this.table.getColumnNo(string.substring(5));
                this.numberTypeData = new String[this.rowCount];
                int n = 1;
                for (int i = 0; i < this.rowCount; ++i) {
                    String string2 = (String)this.table.getValue(i, this.numberTypeClm);
                    if (string2 != null && string2.length() > 0) {
                        this.numberTypeData[i] = String.valueOf(n);
                        ++n;
                        continue;
                    }
                    this.numberTypeData[i] = "";
                }
            } else if (string.startsWith("view=")) {
                this.numberTypeClm = this.getColumnNo(string.substring(5));
            } else if (string.startsWith("delete")) {
                this.numberDisplay = false;
            } else {
                String string3 = "numberType\u5c5e\u6027\u306e\u5024\u304c\u4e0d\u6b63\u3067\u3059\u3002numberType=[" + this.numberType + "]" + CR + "\u8a2d\u5b9a\u3067\u304d\u308b\u306e\u306f\u3001sequence/none/delete/skip=\u30ab\u30e9\u30e0\u540d/view=\u30ab\u30e9\u30e0\u540d/ \u3067\u3059\u3002";
                throw new HybsSystemException(string3);
            }
        }
    }

    protected String getSelectedType() {
        return this.selectedType;
    }

    protected String getNumberData(int n) {
        String string = null;
        if (this.numberType == null || this.numberType.startsWith("se")) {
            string = String.valueOf(n + 1);
        } else if (this.numberType.startsWith("no")) {
            string = "";
        } else if (this.numberType.startsWith("vi")) {
            string = this.getRendererValue(n, this.numberTypeClm);
        } else if (this.numberType.startsWith("sk")) {
            string = this.numberTypeData[n];
        }
        return string;
    }

    protected String getNumberHeader() {
        String string = NO_HEADER;
        if (this.numberType.startsWith("no")) {
            string = "";
        }
        return string;
    }

    @Override
    public void setOptionTypeAttributes(String string) {
        this.optTypeAttri = string;
    }

    protected String getOptionTypeAttributes() {
        return this.optTypeAttri;
    }

    protected int getLastNo(int n, int n2) {
        int n3 = n + (n2 < 0 ? this.getPageSize() : n2);
        if (n3 > this.rowCount) {
            n3 = this.rowCount;
        }
        if (this.rowCount < 0 || n < 0 || n3 < 0) {
            String string = "startNo lastNo \u306e\u7bc4\u56f2\u304c\u4e0d\u6b63\u3067\u3059\u3002" + CR + " startNo=" + n + " , lastNo=" + n3 + " , RowCount=" + this.rowCount;
            throw new HybsSystemException(string);
        }
        return n3;
    }

    @Override
    public String getViewFormType() {
        return this.viewFormID;
    }

    @Override
    public void setViewLink(ViewMarker viewMarker) {
        this.viewLink = viewMarker;
        if (this.viewLink != null && this.table != null) {
            this.viewLink.setDBTableModel(this.table);
        }
    }

    @Override
    public void setViewMarker(ViewMarker viewMarker) {
        this.viewMarker = viewMarker;
        if (this.viewMarker != null && this.table != null) {
            this.viewMarker.setDBTableModel(this.table);
        }
    }

    @Override
    public void setEditMarker(ViewMarker viewMarker) {
        this.editMarker = viewMarker;
        if (this.editMarker != null && this.table != null) {
            this.editMarker.setDBTableModel(this.table);
        }
    }

    @Override
    public void setNoMessage(boolean bl) {
        this.noMessage = bl;
    }

    protected DBColumn getDBColumn(int n) {
        return this.dbColumn[n];
    }

    protected void setDBColumn(int n, DBColumn dBColumn) {
        this.dbColumn[n] = dBColumn;
    }

    @Override
    public void setSkip(boolean bl) {
        this.skip = bl;
    }

    protected boolean isSkip(int n) {
        return this.skip && !this.isChecked(n);
    }

    @Override
    public void setUseCheckControl(int n) {
        this.useCheckControl = n;
    }

    protected boolean isUseCheckControl() {
        return this.useCheckControl > 0;
    }

    protected String getAllCheckControl() {
        String string;
        switch (this.useCheckControl) {
            case 1: {
                string = "<input type=\"checkbox\" name=\"ALL_CHECK\" value=\"2\" onClick=\"checkbox(this);\" />";
                break;
            }
            case 2: {
                string = "<input type=\"checkbox\" name=\"ALL_CHECK\" value=\"2\" onClick=\"checkbox(this);\" checked=\"checked\" />";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void setUseTableSorter(boolean bl) {
        this.useTableSorter = bl;
    }

    @Override
    public void makeTableSorterQuery(Map<?, ?> map) {
        if (map == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String[] stringArray;
            String string = (String)entry.getKey();
            if (string == null || string.equalsIgnoreCase("command") || string.equalsIgnoreCase("h_sortClmns") || (stringArray = (String[])entry.getValue()) == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append('&').append(string).append('=');
                stringBuilder.append(StringUtil.urlEncode((String)stringArray[i]));
            }
        }
        if (stringBuilder.length() > 0) {
            this.sorterQuery = stringBuilder.toString();
        }
    }

    protected String getSortedColumnLabel(int n) {
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = this.getColumnLabel(n);
        if (this.useSorterKeys && this.sortKeys[n] || !this.useSorterKeys && this.useTableSorter) {
            stringBuilder.append("<a href=\"?command=VIEW&").append("h_sortClmns").append('=').append(this.dbColumn[n].getName()).append(this.sorterQuery).append("\">").append(string).append("</a>");
        } else {
            stringBuilder.append("<span>").append(string).append("</span>");
        }
        if (this.isClmBulkSet(n)) {
            String string2;
            DBColumnConfig dBColumnConfig = this.dbColumn[n].getConfig();
            dBColumnConfig.setAddNoValue(true);
            String string3 = dBColumnConfig.getEditor();
            if ("RADIO".equals(string3)) {
                dBColumnConfig.setEditor("MENU");
            } else if ("COLUMN".equals(string3)) {
                dBColumnConfig.setEditor("TEXT");
            }
            Attributes attributes = new Attributes();
            if ("CHBOX".equals(string3)) {
                attributes.add("onClick", "bulkSet(this);");
            } else {
                attributes.add("onChange", "bulkSet(this);");
                attributes.add("ondblclick", "bulkPaste(this);");
                attributes.set("NO_MAXLEN", "true");
                attributes.add("style", "float:left;");
                string2 = "," + dBColumnConfig.getDbType() + ",";
                if (",X,K,KX,XK,ALL,".contains(string2)) {
                    attributes.add("class", "W100");
                    dBColumnConfig.setFieldSize("1");
                }
            }
            attributes.add("onkeydown", "ctrlCV(this);");
            dBColumnConfig.setEditorAttributes(attributes);
            dBColumnConfig.removeEditorAttributes("class", "must");
            dBColumnConfig.setUseSLabel("true");
            string2 = dBColumnConfig.getName();
            dBColumnConfig.setName("h_" + string2);
            DBColumn dBColumn = new DBColumn(dBColumnConfig);
            try {
                stringBuilder.append("<br />").append(dBColumn.getEditorValue(null));
            }
            catch (RuntimeException runtimeException) {
                String string4 = "bulkSet \u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + " Label=" + stringBuilder + " , Column=" + string2 + " , Editor=" + string3 + CR + runtimeException.getMessage();
                System.err.println(string4);
            }
        }
        return stringBuilder.toString();
    }

    protected boolean isMustColumn(int n) {
        if (this.nullCheck != null && this.nullCheck.length > 0) {
            for (int i = 0; i < this.nullCheck.length; ++i) {
                if (!this.nullCheck[i].equals(this.dbColumn[n].getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isMustAnyColumn(int n) {
        if (this.mustAnyCheck != null && this.mustAnyCheck.length > 0) {
            for (int i = 0; i < this.mustAnyCheck.length; ++i) {
                if (!this.mustAnyCheck[i].equals(this.dbColumn[n].getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setParam(ConcurrentMap<String, String> concurrentMap) {
        this.viewParam = concurrentMap;
    }

    protected String getParam(String string, String string2) {
        if (this.viewParam == null) {
            return string2;
        }
        String string3 = (String)this.viewParam.get(string);
        return string3 == null ? string2 : string3;
    }

    protected String getParam(String string) {
        return this.viewParam == null ? null : (String)this.viewParam.get(string);
    }

    protected int getIntParam(String string) {
        String string2 = this.viewParam == null ? null : (String)this.viewParam.get(string);
        return string2 == null ? -1 : Integer.parseInt(string2);
    }

    protected boolean getBoolParam(String string) {
        return this.viewParam != null && Boolean.parseBoolean((String)this.viewParam.get(string));
    }

    @Override
    public void setViewArrayList(List<String[]> list) {
        this.viewArrayList = list;
    }

    protected List<String[]> getViewArrayList() {
        return this.viewArrayList;
    }

    protected boolean isNumberDisplay() {
        return this.numberDisplay;
    }

    @Override
    public void markerSet(ViewForm viewForm) {
        if (viewForm instanceof AbstractViewForm) {
            this.viewLink = ((AbstractViewForm)viewForm).viewLink;
            if (this.viewLink != null) {
                this.viewLink.setDBTableModel(this.table);
            }
            this.viewMarker = ((AbstractViewForm)viewForm).viewMarker;
            if (this.viewMarker != null) {
                this.viewMarker.setDBTableModel(this.table);
            }
            this.editMarker = ((AbstractViewForm)viewForm).editMarker;
            if (this.editMarker != null) {
                this.editMarker.setDBTableModel(this.table);
            }
        } else {
            String string = "AbstractViewForm \u4ee5\u5916\u306e view \u306f\u3001\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002 view=[" + viewForm + "]";
            throw new HybsSystemException(string);
        }
    }

    @Override
    public void setBgColorCycle(int n) {
        this.bgColorCycle = 1;
        if (n > 0) {
            this.colorRow0 = BG_COLOR_ROW0;
            this.colorRow1 = BG_COLOR_ROW1;
            this.bgColorCycle = n;
        } else if (n == -1) {
            this.colorRow0 = BG_WARNING_COLOR_ROW0;
            this.colorRow1 = BG_WARNING_COLOR_ROW1;
        } else if (n < -1) {
            this.colorRow0 = BG_ERROR_COLOR_ROW0;
            this.colorRow1 = BG_ERROR_COLOR_ROW1;
        } else {
            this.colorRow0 = "";
            this.colorRow1 = "";
        }
    }

    @Override
    public void setBgColorClsClm(String string) {
        if (string != null) {
            this.bgColorClsClmNo = this.table.getColumnNo(string);
        }
    }

    protected String getBgColorCycleClass(int n, int n2) {
        return this.useSelRowColor && this.scrollRowNo == n2 ? BG_COLOR_ROWSEL : this.getBgColorCycleClass(n);
    }

    protected String getBgColorCycleClass(int n) {
        String string;
        String string2 = null;
        if (this.bgColorClsClmNo >= 0 && (string = (String)this.table.getValue(n, this.bgColorClsClmNo)) != null && string.length() > 0) {
            string2 = " class=\"row_" + string + "\"";
        }
        if (string2 == null) {
            string2 = n / this.bgColorCycle % 2 == 0 ? this.colorRow0 : this.colorRow1;
        }
        return string2;
    }

    @Override
    public void setUseScrollBar(boolean bl) {
        this.useScrollBar = bl;
    }

    protected String getScrollBarStartDiv() {
        String string;
        if (this.useScrollBar) {
            StringBuilder stringBuilder = new StringBuilder(200).append("<div id=\"divPos\" style=\"");
            if (this.height != null) {
                stringBuilder.append("height:").append(this.height).append(';');
            }
            if (this.width != null) {
                stringBuilder.append("width:").append(this.width).append(';');
            }
            stringBuilder.append("\" ><div id=\"outer\"><div id=\"layer\" onscroll=\"SetScrollHeader(this);\"><div id=\"divHide\">");
            string = stringBuilder.toString();
        } else {
            string = "";
        }
        return string;
    }

    protected String getScrollBarEndDiv() {
        String string = "";
        if (this.useScrollBar) {
            string = LAYER_END2;
        }
        return string;
    }

    @Override
    public void setScrollRowNo(int n, boolean bl) {
        this.scrollRowNo = n;
        this.firstChecked = false;
        this.useSelRowColor = bl;
    }

    @Override
    public void setWritableControl(String string) {
        this.setBooleanArray(string, true, this.writeCtrl);
    }

    protected void setBooleanArray(String string, boolean bl, boolean[] blArray) {
        if (string != null) {
            if ("*".equals(string)) {
                Arrays.fill(blArray, bl);
            } else if ("-".equals(string) || string.isEmpty()) {
                Arrays.fill(blArray, !bl);
            } else {
                Arrays.fill(blArray, !bl);
                String[] stringArray = StringUtil.csv2Array((String)string);
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    if (stringArray[i] == null || stringArray[i].length() <= 0 || (n = this.table.getColumnNo(stringArray[i])) < 0) continue;
                    blArray[n] = bl;
                }
            }
        }
    }

    @Override
    public void setPopupReturnKeys(String string) {
    }

    @Override
    public void setTableClass(String string) {
        if (string != null) {
            this.clazz = string;
        }
    }

    protected String getTableClass() {
        return this.clazz + " " + this.viewClass;
    }

    @Override
    public void setHeight(String string) {
        this.height = string;
    }

    protected String getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(String string) {
        this.width = string;
    }

    protected String getWidth() {
        return this.width;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public void setSkipNoEdit(boolean bl) {
        this.skipNoEdit = bl;
    }

    protected boolean isSkipNoEdit(int n) {
        return this.skipNoEdit && (this.table.getModifyType(n) == null || this.table.getModifyType(n).isEmpty());
    }

    @Override
    public void setNoTransition(boolean bl) {
        this.noTransition = bl;
    }

    protected boolean isNoTransition() {
        return this.noTransition;
    }

    protected String getHiddenRowValue(int n) {
        String string = "";
        if (this.table.getModifyType(n) != null && this.table.getModifyType(n).length() > 0) {
            string = " kh=\"" + this.table.getModifyType(n) + "\"";
        }
        return " rid=\"" + n + "\"" + string;
    }

    @Override
    public String getViewClms() {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < this.clmDisplay.length; ++i) {
            if (!this.clmDisplay[i] || this.rowWritableFlag && i == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.dbColumn[i].getName());
        }
        return stringBuilder.toString();
    }

    protected String getViewClms(TableFormatter tableFormatter) {
        return tableFormatter.getLocationStream().filter(n -> n >= 0).mapToObj(n -> this.table.getColumnName(n)).collect(Collectors.joining(","));
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void setGamenId(String string) {
        this.gamenId = string;
    }

    @Override
    public String getGamenId() {
        return this.gamenId;
    }

    protected boolean isClmBulkSet(int n) {
        return this.clmBulkSet[n] && this.clmWritable[n];
    }

    @Override
    public void setColumnBulkSet(String string) {
        int[] nArray;
        this.setBooleanArray(string, true, this.clmBulkSet);
        if (this.editMarker != null && (nArray = this.editMarker.getColumnNos()) != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.clmBulkSet[nArray[i]] = false;
            }
        }
    }

    protected void setFormatNoDisplay(TableFormatter tableFormatter) {
        int n = tableFormatter.getLocationSize();
        for (int i = 0; i < n; ++i) {
            int n2 = tableFormatter.getLocation(i);
            if (n2 < 0 || this.isColumnDisplay(n2)) continue;
            tableFormatter.setNoDisplay(i);
        }
    }

    @Override
    public void setViewClass(String string) {
        if (string != null) {
            this.viewClass = string;
        }
    }

    protected String getViewClass() {
        return this.viewClass;
    }

    private static enum CLM_GRP {
        KIGO,
        CHAR;

    }
}

