/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgBuilder;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;

public class QueryMaker {
    private static final String QUERY_TYPE = "SELECT,INSERT,UPDATE,DELETE,MERGE";
    private final List<String> whrList = new ArrayList<String>();
    private String queryType;
    private String table;
    private String names;
    private String omitNames;
    private String where;
    private String whrNames;
    private String orderBy;
    private String cnstKeys;
    private String cnstVals;
    private int clmLen;
    private boolean isSetup;
    private String[] nameAry;

    private void setup() {
        if (this.isSetup) {
            return;
        }
        if (StringUtil.isNull(this.table)) {
            String string = "\u6307\u5b9a\u306e table \u306b\u3001null\u3001\u30bc\u30ed\u6587\u5b57\u5217\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 table=" + this.table;
            throw new OgRuntimeException(string);
        }
        if (StringUtil.isNull(this.names)) {
            String string = "\u6307\u5b9a\u306e names \u306b\u3001null\u3001\u30bc\u30ed\u6587\u5b57\u5217\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 names=" + this.names;
            throw new OgRuntimeException(string);
        }
        String[] stringArray = StringUtil.csv2Array(this.names);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
        String[] stringArray2 = StringUtil.csv2Array(this.omitNames);
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray2));
        linkedHashSet.removeAll(hashSet);
        this.clmLen = linkedHashSet.size();
        this.nameAry = linkedHashSet.toArray(new String[this.clmLen]);
        this.where = StringUtil.join(" AND ", this.whrNames, this.formatSplit(this.where));
        this.isSetup = true;
    }

    public String getSelectSQL() {
        if (!"SELECT".equals(this.queryType)) {
            String string = "\u6307\u5b9a\u306eQUERY\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308bSQL\u6587\u3092\u8981\u6c42\u3057\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + " \u8981\u6c42SQL=SELECT  queryType=" + this.queryType;
            throw new OgRuntimeException(string);
        }
        this.setup();
        return new OgBuilder().append("SELECT ").join(",", this.nameAry).append(" FROM ", this.table).appendNN(" WHERE ", this.where).appendNN(" ORDER BY ", this.orderBy).toString();
    }

    public String getInsertSQL() {
        if (!"INSERT".equals(this.queryType) && !"MERGE".equals(this.queryType)) {
            String string = "\u6307\u5b9a\u306eQUERY\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308bSQL\u6587\u3092\u8981\u6c42\u3057\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + " \u8981\u6c42SQL=INSERT  queryType=" + this.queryType;
            throw new OgRuntimeException(string);
        }
        this.setup();
        return new OgBuilder().append("INSERT INTO ").append(this.table).append(" ( ").join(",", this.nameAry).appendNN(",", this.cnstKeys).append(" ) VALUES ( ").appendRoop(0, this.clmLen, ",", n -> "?").appendNN(",", this.cnstVals).append(" )").toString();
    }

    public String getUpdateSQL() {
        if (!"UPDATE".equals(this.queryType) && !"MERGE".equals(this.queryType)) {
            String string = "\u6307\u5b9a\u306eQUERY\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308bSQL\u6587\u3092\u8981\u6c42\u3057\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + " \u8981\u6c42SQL=UPDATE  queryType=" + this.queryType;
            throw new OgRuntimeException(string);
        }
        this.setup();
        String[] stringArray = StringUtil.csv2Array(this.cnstKeys);
        String[] stringArray2 = StringUtil.csv2Array(this.cnstVals);
        if (stringArray.length == 0 || stringArray2.length == 0 || stringArray.length != stringArray2.length) {
            String string = "\u6307\u5b9a\u306e keys,vals \u306b\u306f\u3001null\u3001\u30bc\u30ed\u4ef6\u914d\u5217\u3001\u307e\u305f\u306f\u3001\u500b\u6570\u9055\u3044\u306e\u914d\u5217\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 keys=" + this.cnstKeys + " vals=" + this.cnstVals;
            throw new OgRuntimeException(string);
        }
        if (this.nameAry == null) {
            throw new OgRuntimeException("\u4f55\u3089\u304b\u306e\u4e0d\u6e2c\u306e\u4e8b\u614b\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u672c\u6765\u3001\u3053\u306e\u30a8\u30e9\u30fc\u306f\u51fa\u307e\u305b\u3093\u3002");
        }
        return new OgBuilder().append("UPDATE ").append(this.table).append(" SET ").appendRoop(0, this.clmLen, ",", n -> this.nameAry[n] + "=?").appendRoop(0, stringArray2.length, ",", n -> stringArray[n] + "=" + stringArray2[n]).appendNN(" WHERE ", this.where).toString();
    }

    public String getDeleteSQL() {
        if (!"DELETE".equals(this.queryType)) {
            String string = "\u6307\u5b9a\u306eQUERY\u30bf\u30a4\u30d7\u3068\u7570\u306a\u308bSQL\u6587\u3092\u8981\u6c42\u3057\u3066\u3044\u307e\u3059\u3002" + HybsConst.CR + " \u8981\u6c42SQL=DELETE  queryType=" + this.queryType;
            throw new OgRuntimeException(string);
        }
        this.setup();
        return new OgBuilder().append("DELETE FROM ").append(this.table).appendNN(" WHERE ", this.where).toString();
    }

    private String formatSplit(String string) {
        if (StringUtil.isNull(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = 0;
        int n2 = string.indexOf(91);
        while (n2 >= 0) {
            int n3 = string.indexOf(93, n2);
            if (n3 < 0) {
                String string2 = "[ \u3068 ] \u3068\u306e\u5bfe\u5fdc\u95a2\u4fc2\u304c\u305a\u308c\u3066\u3044\u307e\u3059\u3002format=[" + string + "] : index=" + n2;
                throw new OgRuntimeException(string2);
            }
            if (n2 > 0) {
                stringBuilder.append(string.substring(n, n2));
            }
            this.whrList.add(string.substring(n2 + 1, n3));
            stringBuilder.append('?');
            n = n3 + 1;
            n2 = string.indexOf(91, n);
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public void setQueryType(String string) {
        if (!StringUtil.isNull(string)) {
            if (QUERY_TYPE.contains(string)) {
                this.queryType = string;
            } else {
                throw new OgRuntimeException("queryType \u306f\u3001SELECT,INSERT,UPDATE,DELETE,MERGE \u304b\u3089\u3001\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
    }

    public void setTable(String string) {
        if (!StringUtil.isNull(string)) {
            this.table = string;
        }
    }

    public String getTable() {
        return this.table;
    }

    public void setNames(String string) {
        if (!StringUtil.isNull(string)) {
            this.names = string.toUpperCase(Locale.JAPAN);
        }
    }

    public String getNames() {
        return this.names;
    }

    public void setOmitNames(String string) {
        if (!StringUtil.isNull(string)) {
            this.omitNames = string.toUpperCase(Locale.JAPAN);
        }
    }

    public void setWhere(String string) {
        if (!StringUtil.isNull(string)) {
            this.where = string;
        }
    }

    public void setWhereNames(String string) {
        if (!StringUtil.isNull(string)) {
            String[] stringArray = StringUtil.csv2Array(string);
            StringJoiner stringJoiner = new StringJoiner(" AND ");
            for (String string2 : stringArray) {
                this.whrList.add(string2);
                stringJoiner.add(string2 + "=?");
            }
            this.whrNames = stringJoiner.toString();
        }
    }

    public void setOrderBy(String string) {
        if (!StringUtil.isNull(string)) {
            this.orderBy = string;
        }
    }

    public void setConstKeys(String string) {
        if (!StringUtil.isNull(string)) {
            this.cnstKeys = string;
        }
    }

    public void setConstVals(String string) {
        if (!StringUtil.isNull(string)) {
            this.cnstVals = string;
        }
    }

    public String[] getParamNames(boolean bl) {
        if (!this.isSetup || StringUtil.isNull(this.queryType) || this.nameAry == null) {
            throw new OgRuntimeException("getParamNames(boolean) \u306f\u3001SQL\u6587\u3092\u53d6\u5f97\u3057\u3066\u304b\u3089\u3001\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        String[] stringArray = this.whrList.toArray(new String[this.whrList.size()]);
        String[] stringArray2 = Arrays.copyOf(this.nameAry, this.nameAry.length + this.whrList.size());
        System.arraycopy(stringArray, 0, stringArray2, this.nameAry.length, stringArray.length);
        String[] stringArray3 = null;
        switch (this.queryType) {
            case "SELECT": {
                stringArray3 = new String[]{};
                break;
            }
            case "INSERT": {
                stringArray3 = this.nameAry;
                break;
            }
            case "UPDATE": {
                stringArray3 = stringArray2;
                break;
            }
            case "DELETE": {
                stringArray3 = stringArray;
                break;
            }
            case "MERGE": {
                stringArray3 = stringArray2;
                break;
            }
        }
        if (bl && "MERGE".equals(this.queryType)) {
            stringArray3 = this.nameAry;
        }
        return stringArray3;
    }
}

