<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="init" >
	<!-- 2017/04/20 MOD ﾘｸｴｽﾄﾊﾟﾗﾒｰﾀに[&GAMENID=21_WHTSNEWV]を追加 -->
	<script type="text/javascript">//<![CDATA[
	function popup_window(arg1){
		tmp = "meisai.jsp?command=NEW&GAMENID=21_WHTSNEWV&UNIQ=" + arg1;
		window.open(tmp, '', 'width=830,height=400,scrollbars=yes');
		return false;
	}
	//]]>
	</script>
</og:head>

<!-- 新着情報-->
<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}" dbid="RESOURCE" scope="request">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	 SYSTEM_ID												<!-- ｼｽﾃﾑID-->
	--			,SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ-->
				,CDDEG													<!-- 属性-->
				,TITLE													<!-- ﾀｲﾄﾙ-->
				,SUBSTR(NAIYO,1,100)	GAIYO1							<!-- 概要-->
	--			,NAIYO					NAIYO							<!-- 内容-->
				,MAND													<!-- 掲載者-->
				,DYSTRD													<!-- 掲載開始日-->
	--			,DYENDD													<!-- 掲載終了日-->
	--			,FGJ													<!-- (非表示)状況-->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ-->
	--			,BUSHOD													<!-- (非表示)掲載部署-->
	--			,TEL													<!-- (非表示)電話番号-->
	--			,MAILAD													<!-- (非表示)ﾒｰﾙｱﾄﾞﾚｽ-->
	--			,FILE1													<!-- (非表示)ﾌｧｲﾙ1-->
	--			,FILE2													<!-- (非表示)ﾌｧｲﾙ2-->
	--			,FILE3													<!-- (非表示)ﾌｧｲﾙ3-->
	--			,'{@SYS.REAL_PATH}'||FILEPATH	PARENT					<!-- (非表示)ﾌｧｲﾙ保管場所-->
		FROM	GE81
		<og:where>
			<og:and value = "DYSTRD 	&lt;= '{@USER.YMD}'"/>
			<og:and value = "DYENDD 	&gt;= '{@USER.YMD}'"/>
			<og:and value = "SYSTEM_ID	=	'{@SYS.SYSTEM_ID}'"	/>
			<og:and value = "SYSCODE	IN	('{@USER.SYSCODE}','*')"	/>
			<og:and value = "FGJ		IN	('0','1')"		/>
		</og:where>
		ORDER BY DYSTRD DESC,UNIQ DESC
</og:query>

<og:columnEditor columns="GAIYO1" renderer="SLABEL" param="30" scope="request" />

<!-- ViewMarkerTag	-->
<og:viewMarker command="NEW">
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="1">
		<span class="CDDEG1">[TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="2">
		<span class="CDDEG2">({@LBL.CDDEG.2}) [TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="TITLE" markList="[CDDEG]" onMark="3">
		<span class="CDDEG3">({@LBL.CDDEG.3}) [TITLE]</span>
	</og:columnMarker>
	<og:columnMarker column="DYSTRD" markList="[DYSTRD]" onMark="{@USER.YMD}">
		<span class="TODAY">[DYSTRD]</span>
	</og:columnMarker>
	<og:columnMarker column="GAIYO1">
		<og:link column="GAIYO1" href="#" onClick="popup_window([UNIQ]);"/>
	</og:columnMarker>
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<div class="WHATSNEW">
<og:view
	viewFormType	= "HTMLCustomTable" 
	command			= "NEW" 
	scope			= "request"
	writable		= "false"
	useAfterHtmlTag	= "false"
	rowspan			= "1"
	pageSize		= "20"
	numberType		= "delete"
	noMessage		= "true"
	width			= "100%"
	useScrollBar	= "false" >
	<og:thead rowspan="1">
		<tr><td colspan="4" class="WN-HEAD">{@LBL.21_WHTSNEWV}
			  <div style="position:absolute;right:0px;top:0px;">
				<og:link href="#" onClick="location.reload();return false;" useGamenId="false">
					<og:img  src="{@SYS.JSP}/image/reload.png" alt="reload"/>
				</og:link>
				<og:link href="index.jsp" gamenId="21_WHTSNEW" target="_blank" useGamenId="false" keys="command,CHECK" vals="NEW,1">
					<og:img src="{@SYS.JSP}/image/EditFile.gif" alt="edit" />
				</og:link>
			  </div>
			</td>
		</tr>
	</og:thead>
	<og:tbody rowspan="1">
		<tr style="background-color:transparent;">
			<td>[$TITLE]</td>														<!-- ﾀｲﾄﾙ-->
			<td style="padding-left:0.5em;padding-right:0.5em;">[$GAIYO1]</td>		<!-- 概要-->
			<td>[$DYSTRD]</td>														<!-- 掲載開始日-->
			<td>[$MAND]</td>														<!-- 掲載者-->
		</tr>
	</og:tbody>
	<og:tfoot rowspan="1">
		<tr>
			<td colspan="4" style="font-size:small">
				<og:link href="index.jsp" gamenId="21_WHTSNEWV" keys="command" vals="INIT" target="_blank" lbl="MSG0082" />
			</td>
		</tr>
	</og:tfoot>
</og:view>
</div>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
