<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC10"
	title	= "JSPチェック確認"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select MSGCD,count(*) AS CNT,MSGTXT
		from GF70 A
		where SYSTEM_ID = '{@SYSTEM_ID}'
		and   TBLSYU    = '{@TBLSYU}'
		and   FGJ       in  ('0','1')
	<og:where startKey = "and" >
		<og:and value = "FGOMIT		= '{@FGOMIT}'"			/>
		<og:and value = "ADDRESS	like '{@ADDRESS}'"		/>
		<og:and value = "FILENAME	like '{@FILENAME}'"	/>
		<og:and value = "TAGNAME	like '{@TAGNAME}'"		/>
		<og:and value = "MODIFIED {@CONDITION} '{@MODIFIED}'" />
		<og:equals val1="{@FGOMIT}" val2="0">
			<og:and>
				not exists ( select 'X' from GF70 B
								where A.SYSTEM_ID  = B.SYSTEM_ID
								and A.TBLSYU   = B.TBLSYU
								and A.ADDRESS  = B.ADDRESS
								and A.FILENAME = B.FILENAME
								and A.TAGNAME  = B.TAGNAME
								and B.FGOMIT   = '1')
			</og:and>
		</og:equals>
		<og:and value = "MSGCD		like '{@MSGCD}'"		/>
		<og:and value = "MSGTXT		like '{@MSGTXT}'"		/>
	</og:where>
		group by MSGCD,MSGTXT
		order by MSGCD,MSGTXT
</og:query>

<og:viewLink command="NEW">
	<og:link column="MSGCD" gamenId="DOC10" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,TBLSYU,FGOMIT,MSGCD"
		vals="NEW,{@SYSTEM_ID},{@TBLSYU},{@FGOMIT},[MSGCD]" />
</og:viewLink>

<b><og:link href="result.jsp" keys="command,displayMsg" vals="RENEW,　" >{@LBL.UNGRPTAG}</og:link></b>
<br />

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
	writable	= "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
