/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.opengion.fukurou.mail.CharCodeConverter;
import org.opengion.fukurou.mail.MailCharset;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.UnicodeCorrecter;

class MailCharsetFactory {
    private MailCharsetFactory() {
    }

    static MailCharset newInstance(String string) {
        MailCharset mailCharset = "MS932".equalsIgnoreCase(string) || "Shift_JIS".equalsIgnoreCase(string) || "Windows-31J".equalsIgnoreCase(string) || "UTF-8".equalsIgnoreCase(string) ? new Mail_8bit_Charset(string) : new Mail_ISO2022JP_Charset();
        return mailCharset;
    }

    private static final class JISDataSource
    implements DataSource {
        private final byte[] data;

        public JISDataSource(String string) {
            try {
                this.data = CharCodeConverter.sjisToJis(UnicodeCorrecter.correctToCP932(string).getBytes("Windows-31J"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string2 = "Windows-31J \u3067\u306e\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + string;
                throw new OgRuntimeException(string2, unsupportedEncodingException);
            }
        }

        public String getContentType() {
            return "text/plain; charset=ISO-2022-JP";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }

        public String getName() {
            return "JISDataSource";
        }
    }

    private static final class Mail_ISO2022JP_Charset
    implements MailCharset {
        private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

        private Mail_ISO2022JP_Charset() {
        }

        @Override
        public void setTextContent(MimeMessage mimeMessage, String string) {
            try {
                mimeMessage.setDataHandler(new DataHandler((DataSource)new JISDataSource(string)));
            }
            catch (MessagingException messagingException) {
                String string2 = "\u6307\u5b9a\u306e\u30c6\u30ad\u30b9\u30c8\u3092\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002text=" + string;
                throw new OgRuntimeException(string2, messagingException);
            }
        }

        @Override
        public String encodeWord(String string) {
            try {
                return "=?ISO-2022-JP?B?" + new String(BASE64EncoderStream.encode((byte[])CharCodeConverter.sjisToJis(UnicodeCorrecter.correctToCP932(string).getBytes("Windows-31J"))), DEFAULT_CHARSET) + "?=";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string2 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u51fa\u6765\u307e\u305b\u3093\u3002text=" + string + " , charset=Windows-31J";
                throw new OgRuntimeException(string2, unsupportedEncodingException);
            }
        }

        @Override
        public InternetAddress getAddress(String string, String string2) {
            try {
                return new InternetAddress(string, this.encodeWord(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u51fa\u6765\u307e\u305b\u3093\u3002address=" + string;
                throw new OgRuntimeException(string3, unsupportedEncodingException);
            }
        }

        @Override
        public String getBit() {
            return "7bit";
        }
    }

    private static final class Mail_8bit_Charset
    implements MailCharset {
        private final String charset;

        public Mail_8bit_Charset(String string) {
            this.charset = string;
        }

        @Override
        public void setTextContent(MimeMessage mimeMessage, String string) {
            try {
                mimeMessage.setText(string, this.charset);
            }
            catch (MessagingException messagingException) {
                String string2 = "\u6307\u5b9a\u306e\u30c6\u30ad\u30b9\u30c8\u3092\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002text=" + string + " , charset=" + this.charset;
                throw new OgRuntimeException(string2, messagingException);
            }
        }

        @Override
        public String encodeWord(String string) {
            try {
                return MimeUtility.encodeText((String)string, (String)this.charset, (String)"B");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string2 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u51fa\u6765\u307e\u305b\u3093\u3002text=" + string + " , charset=" + this.charset;
                throw new OgRuntimeException(string2, unsupportedEncodingException);
            }
        }

        @Override
        public InternetAddress getAddress(String string, String string2) {
            try {
                return new InternetAddress(string, string2, this.charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = "\u6307\u5b9a\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u51fa\u6765\u307e\u305b\u3093\u3002address=" + string + " , charset=" + this.charset;
                throw new OgRuntimeException(string3, unsupportedEncodingException);
            }
        }

        @Override
        public String getBit() {
            return "8bit";
        }
    }
}

