<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7170"
	title	= "JSON"
	date	= "2017/06/02"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" tableId="tbl1" trace="false" scope="request">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        like '{@LANG}%'"       />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>


<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:value key="json" command="SET">
<og:view
	viewFormType = "JSON"
	command    = "{@command}"
	scope="request"
	useHilightRow = "false"
	useAfterHtmlTag = "false"
	useConsistency = "false"
	tableId="tbl1"
	pageSize   = "1000"
/>
</og:value>

<!--
<og:text>{@json}</og:text>
-->

<og:readJSON command="{@command}" debug="{@debug}" modifyType="C">
	{@json}
</og:readJSON>


<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	pageSize   = "1000"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
