<jsp:directive.page pageEncoding="UTF-8" />
<!-- PostgreSQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,CONSTRAINT_NAME AS INDEX_NAME,COLUMN_NAME AS CLM,ORDINAL_POSITION AS SEQNO,
			'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from information_schema.key_column_usage
		where CONSTRAINT_SCHEMA = 'public'
	<og:where startKey="and">
		<og:and value = "TABLE_NAME  like '{@TABLE_NAME}'"  />
	</og:where>
		order by TABLE_NAME,CONSTRAINT_NAME,ORDINAL_POSITION
  </og:query>
</og:equals>

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select TABLE_NAME,INDEX_NAME,COLUMN_NAME AS CLM,COLUMN_POSITION AS SEQNO,
			'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_IND_COLUMNS
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_IND_COLUMNS.TABLE_NAME
					)
		and   INSTR(TABLE_NAME,'$') < 1
		and   INSTR(INDEX_NAME,'$') < 1
		and   INSTR(COLUMN_NAME,'$') < 1
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by TABLE_NAME,INDEX_NAME,COLUMN_POSITION
  </og:query>
</og:equals>

<!-- FIREBIRD 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select  trim(a.RDB$RELATION_NAME)	AS TABLE_NAME, 
				trim(a.RDB$INDEX_NAME)		AS INDEX_NAME, 
				trim(b.RDB$FIELD_NAME)		AS CLM, 
				b.RDB$FIELD_POSITION+1		AS SEQNO, 
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from RDB$INDICES a inner join RDB$INDEX_SEGMENTS b
		on   a.RDB$INDEX_NAME = b.RDB$INDEX_NAME
		where a.RDB$SYSTEM_FLAG = 0
		<og:where startKey="and">
			<og:and value = "a.RDB$RELATION_NAME like '{@TABLE_NAME}'" />
		</og:where>
		order by a.RDB$RELATION_NAME,a.RDB$INDEX_NAME,b.RDB$FIELD_POSITION
  </og:query>
</og:equals>

<!-- MySQL 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="MYSQL">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select	A.TABLE_NAME, 
				A.INDEX_NAME, 
				A.COLUMN_NAME				AS CLM, 
				A.SEQ_IN_INDEX				AS SEQNO, 
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from  information_schema.statistics A left outer join information_schema.table_constraints B
				on  A.table_schema = B.constraint_schema
				and A.TABLE_NAME   = B.TABLE_NAME
				and A.INDEX_NAME   = B.CONSTRAINT_NAME
		where A.table_schema=database()
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}'"  />
		</og:where>
		order by A.TABLE_NAME,A.INDEX_NAME,A.SEQ_IN_INDEX
  </og:query>
</og:equals>

<!-- POSTGRES,ORACLE,FIREBIRD,MYSQL 以外の場合 -->
<og:equals val1="POSTGRES,ORACLE,FIREBIRD,MYSQL" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2040}" val1="{@DBF.NAME @DBID}" />
</og:equals>
