/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.security.URLHashMap;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.ViewMarker;

public class ViewLink_LINK
implements ViewMarker {
    private static final String REQ_KEY = "h_r";
    private static final int ACCS_LVL = HybsSystem.sysInt("URL_ACCESS_SECURITY_LEVEL");
    private static final int MARK_NULL = -1;
    private static final int MARK_TRUE = 1;
    private static final int MARK_FALSE = 0;
    private List<Attributes> markData;
    private final ConcurrentMap<Integer, Formatter> formMap = new ConcurrentHashMap<Integer, Formatter>();
    private final ConcurrentMap<Integer, List<Integer>> clmMap = new ConcurrentHashMap<Integer, List<Integer>>();
    private DBTableModel table;
    private int[] markCmlNo;
    private int[] isMark;
    private int[] hrefIn;
    private int[] encodeIn;
    private int[] encodeOut;
    private String[] markKey;
    private String[] markLists;
    private int[] markListNo;
    private boolean[] useURLCheck;
    private String[] urlCheckUser;
    private long[] urlCheckTime;
    private HybsCryptography[] urlCheckCrypt;
    private boolean[] useHrefEncode;
    private int editClmNo;

    @Override
    public void clear() {
        this.markData = null;
        this.formMap.clear();
        this.table = null;
        this.isMark = null;
        this.hrefIn = null;
        this.encodeIn = null;
        this.encodeOut = null;
        this.markKey = null;
        this.markLists = null;
        this.markListNo = null;
        this.clmMap.clear();
        this.useURLCheck = null;
        this.urlCheckUser = null;
        this.urlCheckTime = null;
        this.urlCheckCrypt = null;
        this.useHrefEncode = null;
        this.editClmNo = -1;
    }

    @Override
    public void addAttribute(Attributes attributes) {
        if (this.markData == null) {
            this.markData = new ArrayList<Attributes>();
        }
        this.markData.add(attributes);
    }

    @Override
    public boolean isUsable() {
        return this.markData != null && this.markData.size() > 0;
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
        int n2 = this.markData.size();
        this.isMark = new int[n2];
        this.markKey = new String[n2];
        this.markCmlNo = new int[n2];
        this.markLists = new String[n2];
        this.markListNo = new int[n2];
        this.hrefIn = new int[n2];
        this.encodeIn = new int[n2];
        this.encodeOut = new int[n2];
        this.useURLCheck = new boolean[n2];
        this.urlCheckUser = new String[n2];
        this.urlCheckTime = new long[n2];
        this.urlCheckCrypt = new HybsCryptography[n2];
        this.useHrefEncode = new boolean[n2];
        Arrays.fill(this.isMark, 0);
        Arrays.fill(this.markCmlNo, -1);
        Arrays.fill(this.hrefIn, 10000);
        Arrays.fill(this.encodeIn, 10000);
        Arrays.fill(this.encodeOut, -1);
        Arrays.fill(this.useURLCheck, false);
        Arrays.fill(this.urlCheckTime, 0L);
        Arrays.fill(this.useHrefEncode, false);
        this.editClmNo = this.table.getColumnNo("rowCount", false);
        for (int i = 0; i < n2; ++i) {
            String string;
            boolean bl;
            Attributes attributes = this.markData.get(i);
            String string2 = attributes.get("column");
            int n3 = this.table.getColumnNo(string2, bl = !"false".equalsIgnoreCase(string = attributes.get("strictCheck")));
            if (n3 < 0) continue;
            this.clmMap.computeIfAbsent(n3, n -> new ArrayList()).add(i);
            String string3 = attributes.get("linkFormat");
            string3 = StringUtil.replace((String)string3, (String)"%5B", (String)"[");
            string3 = StringUtil.replace((String)string3, (String)"%5D", (String)"]");
            Formatter formatter = new Formatter((DataModel)this.table, string3);
            this.formMap.put(i, formatter);
            String[] stringArray = formatter.getFormat();
            boolean bl2 = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (stringArray[j] != null && stringArray[j].indexOf("href") >= 0) {
                    bl2 = true;
                    this.hrefIn[i] = j;
                }
                if (bl2 && stringArray[j].indexOf(63) >= 0) {
                    this.encodeIn[i] = j;
                }
                if (!bl2 || stringArray[j].indexOf("\" ") < 0) continue;
                this.encodeOut[i] = j;
                bl2 = false;
            }
            this.useURLCheck[i] = StringUtil.nval((String)attributes.get("useURLCheck"), (boolean)false);
            this.urlCheckUser[i] = StringUtil.nval((String)attributes.get("urlCheckUser"), null);
            this.urlCheckTime[i] = StringUtil.nval((String)attributes.get("urlCheckTime"), (long)0L);
            String string4 = StringUtil.nval((String)attributes.get("urlCheckCrypt"), null);
            this.urlCheckCrypt[i] = new HybsCryptography(string4);
            this.useHrefEncode[i] = StringUtil.nval((String)attributes.get("useHrefEncode"), (boolean)false);
            this.makeOnLinkFormat(i, attributes);
        }
    }

    @Override
    public String getMarkerString(int n, int n2, String string) {
        String string2;
        int n3;
        int n4 = this.isOnLink(n, n2);
        if (n4 < 0) {
            return string;
        }
        Formatter formatter = (Formatter)this.formMap.get(n4);
        int[] nArray = formatter.getClmNos();
        String[] stringArray = formatter.getFormat();
        StringBuilder stringBuilder = new StringBuilder(500);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            stringBuilder.append(stringArray[n3]);
            string2 = formatter.getValue(n, nArray[n3]);
            if (this.hrefIn[n4] <= n3 && n3 < this.encodeOut[n4]) {
                if (this.encodeIn[n4] <= n3) {
                    string2 = StringUtil.urlEncode((String)string2);
                } else if (this.useHrefEncode[n4]) {
                    string2 = StringUtil.urlEncode2((String)string2);
                }
            } else if (n2 == nArray[n3]) {
                string2 = string;
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append(stringArray[n3]);
        string2 = stringBuilder.toString();
        String string3 = String.valueOf(n);
        string2 = StringUtil.replace((String)string2, (String)"{I}", (String)string3);
        string2 = StringUtil.replace((String)string2, (String)"%7BI%7D", (String)string3);
        if (this.useURLCheck[n4]) {
            string2 = XHTMLTag.embedURLCheckKey((String)string2, (String)"h_urlCheck", (String)this.urlCheckUser[n4], (long)this.urlCheckTime[n4], (HybsCryptography)this.urlCheckCrypt[n4]);
        }
        if (ACCS_LVL == 2) {
            string2 = URLHashMap.makeUrlChange((String)string2, (String)REQ_KEY, (boolean)true);
        } else if (ACCS_LVL == 3) {
            string2 = URLHashMap.makeUrlChange((String)string2, (String)REQ_KEY, (boolean)false);
        }
        return string2;
    }

    private void makeOnLinkFormat(int n, Attributes attributes) {
        String string = attributes.get("onLink");
        String string2 = attributes.get("markList");
        this.isMark[n] = -1;
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            this.isMark[n] = 0;
            return;
        }
        if (string.charAt(0) != '[' && string2.charAt(0) != '[') {
            this.isMark[n] = string2.indexOf(string) >= 0 ? 1 : 0;
            return;
        }
        if (string.charAt(0) == '[') {
            this.markCmlNo[n] = this.table.getColumnNo(string.substring(1, string.length() - 1));
        } else {
            this.markCmlNo[n] = -1;
            this.markKey[n] = string;
        }
        if (string2.charAt(0) == '[') {
            this.markListNo[n] = this.table.getColumnNo(string2.substring(1, string2.length() - 1));
        } else {
            this.markListNo[n] = -1;
            this.markLists[n] = string2;
        }
    }

    private int isOnLink(int n, int n2) {
        if (this.editClmNo >= 0 && StringUtil.nval((String)((String)this.table.getValue(n, this.editClmNo)), null) != null) {
            return -1;
        }
        List list = (List)this.clmMap.get(n2);
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            int n3 = (Integer)list.get(i);
            if (!(this.isMark[n3] != -1 ? this.isMark[n3] == 1 : (string2 = this.markCmlNo[n3] < 0 ? this.markKey[n3] : (String)this.table.getValue(n, this.markCmlNo[n3])) != null && !string2.isEmpty() && (string = this.markListNo[n3] < 0 ? this.markLists[n3] : (String)this.table.getValue(n, this.markListNo[n3])) != null && !string.isEmpty() && string.indexOf(string2) >= 0)) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public int[] getColumnNos() {
        return new int[0];
    }
}

