/**
 * <pre>
 * はやぶさ共通のＸＭＬ関連クラスを提供します。
 * 
 * このパッケージは、単独クラスとして、他のopenGionパッケージと切り離されています。
 * 
 * ここで扱う ＸＭＬファイルは、拡張オラクル ＸＤＫ形式のＸＭＬファイルを処理するクラス群です。
 * オラクルＸＤＫ形式のＸＭＬとは、下記のような ROWSET をトップとする ROW の
 * 集まりで１レコードを表し、各ROWには、カラム名をキーとするXMLになっています。
 * 
 *   &lt;ROWSET&gt;
 *       &lt;ROW num="1"&gt;
 *           &lt;カラム1&gt;値1&lt;/カラム1&gt;
 *             ･･･
 *           &lt;カラムn&gt;値n&lt;/カラムn&gt;
 *       &lt;/ROW&gt;
 *        ･･･
 *       &lt;ROW num="n"&gt;
 *          ･･･
 *       &lt;/ROW&gt;
 *   &lt;ROWSET&gt;
 * 
 * この形式であれば、XDK(Oracle XML Developer's Kit)を利用すれば、非常に簡単に
 * データベースとXMLファイルとの交換が可能です。
 * <a href="http://otn.oracle.co.jp/software/tech/xml/xdk/index.html" target="_blank" >
 * XDK(Oracle XML Developer's Kit)</a>
 * 
 * 拡張ＸＤＫ形式とは、ROW 以外に、SQL処理用タグ(EXEC_SQL)を持つ XML ファイルです。
 * これは、オラクルXDKで処理する場合、無視されますので、同様に扱うことが出来ます。
 * この、EXEC_SQL は、それそれの XMLデータをデータベースに登録する際に、
 * SQL処理を自動的に実行する為の、SQL文を記載できます。
 * このSQL文は、EXEC_SQLタグを処理する都度にイベント処理される為、その配置順は重要です。
 * このタグそのものは、複数記述することが出来ますが、BODY部には、１つのSQL文のみ記述します。
 * 
 *   &lt;ROWSET&gt;
 *       &lt;EXEC_SQL&gt;                    最初に記載して、初期処理（データクリア等）を実行させる。
 *           delete from GEXX where YYYYY
 *       &lt;/EXEC_SQL&gt;
 *       &lt;ROW num="1"&gt;
 *           &lt;カラム1&gt;値1&lt;/カラム1&gt;
 *             ･･･
 *           &lt;カラムn&gt;値n&lt;/カラムn&gt;
 *       &lt;/ROW&gt;
 *        ･･･
 *       &lt;ROW num="n"&gt;
 *          ･･･
 *       &lt;/ROW&gt;
 *       &lt;EXEC_SQL&gt;                    最後に記載して、項目の設定(整合性登録)を行う。
 *           update GEXX set AA='XX' , BB='XX' where YYYYY
 *       &lt;/EXEC_SQL&gt;
 *   &lt;ROWSET&gt;
 * 
 * この、SQL文を登録前に実行すれば、既存データを削除してから、新しいデータを
 * 登録するような使い方が出来ます。
 * このファイルの処理を、タイムスタンプ等で監視すれば、変更時のみ実行する
 * データ登録のファイルを作成することが可能です。
 * また、最後に記載することで、登録後のデータ整合性を処理するSQL文を登録する
 * 事も可能です。
 * 
 *    org.opengion.fukurou.xml (classes)
 *       → org.opengion.fukurou.system                        classes
 *       → org.opengion.fukurou.util                          classes
 * </pre>
 */
package org.opengion.fukurou.xml;
