<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0006"
	title    = "ラベル概要説明"
	date     = "2012/07/10"
	author   = "S.Li"
	text     = "ZZZZ"
	version  = "001"
>
	6.8.2.4 (2017/11/20) K.H (61200-171116-14) 曖昧検索機能追加
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
		'1' as WRITABLE,A.CLM,A.NAME_JA,A.LNAME,A.SNAME,A.DESCRIPTION,A.UNIQ ,A.SYSTEM_ID,A.LANG
		from GEA08 A
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.LANG			=		'{@LANG}'"			/>
		<og:and value = "UPPER(CLM)		like	UPPER('{@CLM}')"	/>
		<og:and value = "A.NAME_JA		like	'{@NAME_JA}'"		/>
		<og:and value = "A.LNAME		like	'{@LNAME}'"			/>
		<og:and value = "A.SNAME		like	'{@SNAME}'"			/>
		<og:and value = "A.DESCRIPTION	like	'{@DESCRIPTION}'"	/>
		<og:and value = "A.KBSAKU		=		'{@KBSAKU}'"		/>
		<og:and value = "A.KBLBL		=		'{@KBLBL}'"			/>
		<og:and value = "A.FGLOAD		=		'{@FGLOAD}'"		/>
		<og:and value = "( A.CLM = A.NAME_JA {@NAME_MI} A.NAME_JA is null )" />
		<og:and value = "A.CDKH {@CDKH}" />
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.CLM,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>

<og:tableMerge
	action        = "GROUP"
	masterKeys    = "CLM,LANG"
	display       = "false"
/>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  value="update"   lbl="MODIFY"    command="MODIFY" accesskey="M"
		keys="columnWritable" vals="DESCRIPTION" />
</og:writeCheck>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,{@SYSTEM_ID},[CLM],1" />
</og:viewLink>
<og:columnEditor column="DESCRIPTION" renderer="TEXTAREA" editor="TEXTAREA" param="60"/>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,SYSTEM_ID,LANG"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
