/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.HybsDateUtil;

public final class DBUpdater {
    public static final int DB_BATCH_SIZE = 100;
    private final PreparedStatement pstmt;
    private final boolean usePMeta;
    private final int[] types;
    private boolean[] isTime;
    private boolean useTimeStamp;
    private int rowCnt = 0;
    private int updCnt = 0;

    public DBUpdater(int n, PreparedStatement preparedStatement) {
        this(n, preparedStatement, true);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl) {
        this.usePMeta = bl;
        this.pstmt = preparedStatement;
        if (bl) {
            this.types = new int[n];
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                boolean bl2 = false;
                for (int i = 0; i < n; ++i) {
                    this.types[i] = parameterMetaData.getParameterType(i + 1);
                }
            }
            catch (SQLException sQLException) {
                throw new OgRuntimeException("ParameterMetaData \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sQLException);
            }
        } else {
            this.types = null;
        }
    }

    public void setTimeStampClms(boolean[] blArray) {
        this.isTime = blArray;
        for (boolean bl : blArray) {
            if (!bl) continue;
            this.useTimeStamp = true;
            break;
        }
    }

    public void execute(String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            int n;
            ++this.rowCnt;
            if (this.usePMeta) {
                n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string == null || string.isEmpty()) {
                        this.pstmt.setNull(i + 1, this.types[i]);
                        continue;
                    }
                    this.pstmt.setObject(i + 1, (Object)string, this.types[i]);
                }
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    String string = stringArray[n];
                    this.pstmt.setObject(n + 1, string);
                }
            }
            this.pstmt.addBatch();
            if (this.rowCnt % 100 == 0) {
                int[] nArray;
                for (int n2 : nArray = this.pstmt.executeBatch()) {
                    if (n2 <= 0) continue;
                    this.updCnt += n2;
                }
            }
        }
    }

    public void execute(String[] stringArray, boolean[] blArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            ++this.rowCnt;
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (blArray[i] && string != null && !string.isEmpty()) {
                    Timestamp timestamp = Timestamp.valueOf(HybsDateUtil.parseTimestamp(string));
                    this.pstmt.setObject(i + 1, timestamp);
                    continue;
                }
                this.pstmt.setObject(i + 1, string);
            }
            this.pstmt.addBatch();
            if (this.rowCnt % 100 == 0) {
                int[] nArray = this.pstmt.executeBatch();
                for (Object object : (String)nArray) {
                    if (object <= 0) continue;
                    this.updCnt += object;
                }
            }
        }
    }

    public int execEnd() throws SQLException {
        int[] nArray;
        for (int n : nArray = this.pstmt.executeBatch()) {
            if (n <= 0) continue;
            this.updCnt += n;
        }
        return this.updCnt;
    }
}

