/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;

public class Query_JDBCPrepared
extends AbstractQuery {
    private static final String VERSION = "6.4.2.1 (2016/02/05)";

    public void execute(String ... stringArray) {
        try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(this.getStatement());){
            preparedStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            for (int i = 0; i < stringArray.length; ++i) {
                preparedStatement.setString(i + 1, StringUtil.rTrim((String)stringArray[i]));
            }
            if (preparedStatement.execute()) {
                try (ResultSet resultSet = preparedStatement.getResultSet();){
                    resultSet.setFetchSize(DB_FETCH_SIZE);
                    this.createTableModel(resultSet);
                    this.setUpdateFlag(false);
                }
            } else {
                this.setExecuteCount(preparedStatement.getUpdateCount());
            }
            this.setErrorCode(0);
        }
        catch (SQLException sQLException) {
            this.setErrorCode(8);
            String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + this.getStatement() + CR;
            throw new HybsSystemException(string, (Throwable)sQLException);
        }
    }
}

