/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractQuery;
import org.opengion.hayabusa.db.DBErrMsg;

public class Query_JDBCKeyEntry
extends AbstractQuery {
    private static final String VERSION = "6.4.2.1 (2016/02/05)";

    public void execute(String[] stringArray, String ... stringArray2) {
        Connection connection = this.getConnection();
        try (CallableStatement callableStatement = connection.prepareCall(this.getStatement());){
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            callableStatement.setFetchSize(DB_FETCH_SIZE);
            Map<String, Class<?>> map = connection.getTypeMap();
            map.put("ERR_MSG", DBErrMsg.class);
            Array array = ((OracleConnection)connection).createOracleArray("ARG_ARRAY", (Object)stringArray);
            Array array2 = ((OracleConnection)connection).createOracleArray("ARG_ARRAY", (Object)StringUtil.rTrims((String[])stringArray2));
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 2003, "ERR_MSG_ARRAY");
            callableStatement.setArray(3, array);
            callableStatement.setArray(4, array2);
            callableStatement.execute();
            int n = callableStatement.getInt(1);
            this.setErrorCode(n);
            if (n > 0) {
                DBErrMsg dBErrMsg;
                Array array3 = callableStatement.getArray(2);
                Object[] objectArray = (Object[])array3.getArray();
                ErrorMessage errorMessage = new ErrorMessage("Query_JDBCKeyEntry Error!!");
                for (int i = 0; i < objectArray.length && (dBErrMsg = (DBErrMsg)objectArray[i]) != null; ++i) {
                    errorMessage.addMessage(dBErrMsg.getErrMsg());
                }
                this.setErrorMessage(errorMessage);
            }
        }
        catch (SQLException sQLException) {
            this.setErrorCode(8);
            String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + CR + this.getStatement() + CR;
            throw new HybsSystemException(string, (Throwable)sQLException);
        }
    }
}

